/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.debug;

import java.util.Map;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.Bond;
import org.openscience.cdk.debug.DebugChemObjectBuilder;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IChemObjectListener;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugBond
extends Bond
implements IBond {
    private static final long serialVersionUID = -2330398179697796261L;
    ILoggingTool logger = LoggingToolFactory.createLoggingTool(DebugBond.class);

    public DebugBond() {
    }

    public DebugBond(IAtom atom1, IAtom atom2) {
        super(atom1, atom2);
    }

    public DebugBond(IAtom atom1, IAtom atom2, IBond.Order order) {
        super(atom1, atom2, order);
    }

    public DebugBond(IAtom atom1, IAtom atom2, IBond.Order order, IBond.Stereo stereo) {
        super(atom1, atom2, order, stereo);
    }

    public DebugBond(IAtom[] atoms) {
        super(atoms);
    }

    public DebugBond(IAtom[] atoms, IBond.Order order) {
        super(atoms, order);
    }

    @Override
    public Integer getElectronCount() {
        this.logger.debug("Getting electron count: ", super.getElectronCount());
        return super.getElectronCount();
    }

    @Override
    public void setElectronCount(Integer electronCount) {
        this.logger.debug("Setting electron count: ", electronCount);
        super.setElectronCount(electronCount);
    }

    @Override
    public void addListener(IChemObjectListener col) {
        this.logger.debug("Adding listener: ", col);
        super.addListener(col);
    }

    @Override
    public int getListenerCount() {
        this.logger.debug("Getting listener count: ", super.getListenerCount());
        return super.getListenerCount();
    }

    @Override
    public void removeListener(IChemObjectListener col) {
        this.logger.debug("Removing listener: ", col);
        super.removeListener(col);
    }

    @Override
    public void notifyChanged() {
        this.logger.debug("Notifying changed");
        super.notifyChanged();
    }

    @Override
    public void notifyChanged(IChemObjectChangeEvent evt) {
        this.logger.debug("Notifying changed event: ", evt);
        super.notifyChanged(evt);
    }

    @Override
    public void setProperty(Object description, Object property) {
        this.logger.debug("Setting property: ", description + "=" + property);
        super.setProperty(description, property);
    }

    @Override
    public void removeProperty(Object description) {
        this.logger.debug("Removing property: ", description);
        super.removeProperty(description);
    }

    public Object getProperty(Object description) {
        this.logger.debug("Getting property: ", description + "=" + super.getProperty(description));
        return super.getProperty(description);
    }

    @Override
    public Map<Object, Object> getProperties() {
        this.logger.debug("Getting properties");
        return super.getProperties();
    }

    @Override
    public String getID() {
        this.logger.debug("Getting ID: ", super.getID());
        return super.getID();
    }

    @Override
    public void setID(String identifier) {
        this.logger.debug("Setting ID: ", identifier);
        super.setID(identifier);
    }

    @Override
    public void setFlag(int flag_type, boolean flag_value) {
        this.logger.debug("Setting flag: ", flag_type + "=" + flag_value);
        super.setFlag(flag_type, flag_value);
    }

    @Override
    public boolean getFlag(int flag_type) {
        this.logger.debug("Setting flag: ", flag_type + "=" + super.getFlag(flag_type));
        return super.getFlag(flag_type);
    }

    @Override
    public void setProperties(Map<Object, Object> properties) {
        this.logger.debug("Setting properties: ", properties);
        super.setProperties(properties);
    }

    @Override
    public void setFlags(boolean[] flagsNew) {
        this.logger.debug("Setting flags:", flagsNew.length);
        super.setFlags(flagsNew);
    }

    @Override
    public boolean[] getFlags() {
        this.logger.debug("Getting flags:", super.getFlags().length);
        return super.getFlags();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Object clone = null;
        try {
            clone = super.clone();
        }
        catch (Exception exception) {
            this.logger.error("Could not clone DebugAtom: " + exception.getMessage(), exception);
            this.logger.debug(exception);
        }
        return clone;
    }

    @Override
    public IChemObjectBuilder getBuilder() {
        return DebugChemObjectBuilder.getInstance();
    }

    @Override
    public Iterable<IAtom> atoms() {
        this.logger.debug("Getting atoms iterable");
        return super.atoms();
    }

    @Override
    public void setAtoms(IAtom[] atoms) {
        this.logger.debug("Setting atoms: ", atoms.length);
        super.setAtoms(atoms);
    }

    @Override
    public int getAtomCount() {
        this.logger.debug("Getting atom count: ", super.getAtomCount());
        return super.getAtomCount();
    }

    @Override
    public IAtom getAtom(int position) {
        this.logger.debug("Getting atom at position: ", position);
        return super.getAtom(position);
    }

    @Override
    public IAtom getConnectedAtom(IAtom atom) {
        this.logger.debug("Getting connected atom to atom: ", atom);
        return super.getConnectedAtom(atom);
    }

    @Override
    public boolean contains(IAtom atom) {
        this.logger.debug("Contains atom: ", atom);
        return super.contains(atom);
    }

    @Override
    public void setAtom(IAtom atom, int position) {
        this.logger.debug("Setting atom at position: ", atom);
        super.setAtom(atom, position);
    }

    @Override
    public IBond.Order getOrder() {
        this.logger.debug("Getting order: ", new Object[]{super.getOrder()});
        return super.getOrder();
    }

    @Override
    public void setOrder(IBond.Order order) {
        this.logger.debug("Setting order: ", new Object[]{order});
        super.setOrder(order);
    }

    @Override
    public IBond.Stereo getStereo() {
        this.logger.debug("Getting stereo: ", new Object[]{super.getStereo()});
        return super.getStereo();
    }

    @Override
    public void setStereo(IBond.Stereo stereo) {
        this.logger.debug("Setting stereo: ", new Object[]{stereo});
        super.setStereo(stereo);
    }

    @Override
    public Point2d get2DCenter() {
        this.logger.debug("Getting 2d center: ", super.get2DCenter());
        return super.get2DCenter();
    }

    @Override
    public Point3d get3DCenter() {
        this.logger.debug("Getting 3d center: ", super.get3DCenter());
        return super.get3DCenter();
    }

    @Override
    public boolean compare(Object object) {
        this.logger.debug("Comparing to object: ", object);
        return super.compare(object);
    }

    @Override
    public boolean isConnectedTo(IBond bond) {
        this.logger.debug("Is connected to bond: ", bond);
        return super.isConnectedTo(bond);
    }
}

