/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.aromaticity.CDKHueckelAromaticityDetector;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.qsar.result.IntegerResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@TestClass(value="org.openscience.cdk.qsar.descriptors.molecular.AromaticAtomsCountDescriptorTest")
public class AromaticAtomsCountDescriptor
implements IMolecularDescriptor {
    private boolean checkAromaticity = false;
    private static final String[] names = new String[]{"naAromAtom"};

    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#aromaticAtomsCount", this.getClass().getName(), "$Id$", "The Chemistry Development Kit");
    }

    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
        if (params.length != 1) {
            throw new CDKException("AromaticAtomsCountDescriptor expects one parameter");
        }
        if (!(params[0] instanceof Boolean)) {
            throw new CDKException("The first parameter must be of type Boolean");
        }
        this.checkAromaticity = (Boolean)params[0];
    }

    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        Object[] params = new Object[]{this.checkAromaticity};
        return params;
    }

    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return names;
    }

    @TestMethod(value="testCalculate_IAtomContainer,testAromaticAtomsCountDescriptor,testViaFlags")
    public DescriptorValue calculate(IAtomContainer atomContainer) {
        IAtomContainer ac;
        try {
            ac = (IAtomContainer)atomContainer.clone();
        }
        catch (CloneNotSupportedException e) {
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(0), this.getDescriptorNames(), new CDKException("Error during clone"));
        }
        int aromaticAtomsCount = 0;
        if (this.checkAromaticity) {
            try {
                AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(ac);
            }
            catch (CDKException e) {
                return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(0), this.getDescriptorNames(), new CDKException("Error during atom type perception"));
            }
            try {
                CDKHueckelAromaticityDetector.detectAromaticity(ac);
            }
            catch (CDKException e) {
                return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(0), this.getDescriptorNames(), new CDKException("Error during aromaticity detection: " + e.getMessage()));
            }
        }
        for (int i = 0; i < ac.getAtomCount(); ++i) {
            if (!ac.getAtom(i).getFlag(5)) continue;
            ++aromaticAtomsCount;
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(aromaticAtomsCount), this.getDescriptorNames());
    }

    @TestMethod(value="testGetDescriptorResultType")
    public IDescriptorResult getDescriptorResultType() {
        return new IntegerResult(1);
    }

    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        String[] params = new String[]{"checkAromaticity"};
        return params;
    }

    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        return true;
    }
}

