/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import org.openscience.cdk.Atom;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomParity;
import org.openscience.cdk.interfaces.IChemObjectBuilder;

public class AtomParity
implements IAtomParity,
Serializable {
    private static final long serialVersionUID = -2031408037315976637L;
    private IAtom centralAtom;
    private IAtom[] neighbors;
    private int parity;

    public AtomParity(IAtom centralAtom, IAtom first, IAtom second, IAtom third, IAtom fourth, int parity) {
        this.centralAtom = centralAtom;
        this.neighbors = new Atom[4];
        this.neighbors[0] = first;
        this.neighbors[1] = second;
        this.neighbors[2] = third;
        this.neighbors[3] = fourth;
        this.parity = parity;
    }

    public IAtom getAtom() {
        return this.centralAtom;
    }

    public IAtom[] getSurroundingAtoms() {
        return this.neighbors;
    }

    public int getParity() {
        return this.parity;
    }

    public String toString() {
        StringBuffer resultString = new StringBuffer(32);
        resultString.append("AtomParity(");
        resultString.append(this.hashCode()).append(", ");
        resultString.append(this.centralAtom.getID());
        resultString.append(", F:[").append(this.neighbors[0].getID()).append(", ");
        resultString.append(this.neighbors[1].getID()).append(", ");
        resultString.append(this.neighbors[2].getID()).append(", ");
        resultString.append(this.neighbors[3].getID()).append("], ");
        resultString.append(this.parity);
        resultString.append(')');
        return resultString.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        AtomParity clone = (AtomParity)super.clone();
        clone.centralAtom = (IAtom)this.centralAtom.clone();
        clone.neighbors = new IAtom[4];
        clone.neighbors[0] = (IAtom)this.neighbors[0].clone();
        clone.neighbors[1] = (IAtom)this.neighbors[1].clone();
        clone.neighbors[2] = (IAtom)this.neighbors[2].clone();
        clone.neighbors[3] = (IAtom)this.neighbors[3].clone();
        return clone;
    }

    public IChemObjectBuilder getBuilder() {
        return DefaultChemObjectBuilder.getInstance();
    }
}

