/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fingerprint;

import java.util.BitSet;
import java.util.Map;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.config.fragments.EStateFragments;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fingerprint.BitSetFingerprint;
import org.openscience.cdk.fingerprint.IBitFingerprint;
import org.openscience.cdk.fingerprint.ICountFingerprint;
import org.openscience.cdk.fingerprint.IFingerprinter;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.smiles.smarts.SMARTSQueryTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.fingerprint.EStateFingerprinterTest")
public class EStateFingerprinter
implements IFingerprinter {
    private static final String[] PATTERNS = EStateFragments.getSmarts();

    @TestMethod(value="testFingerprint,testGetSize")
    public EStateFingerprinter() {
    }

    @Override
    @TestMethod(value="testFingerprint")
    public IBitFingerprint getBitFingerprint(IAtomContainer atomContainer) throws CDKException {
        int bitsetLength = PATTERNS.length;
        BitSet fingerPrint = new BitSet(bitsetLength);
        SMARTSQueryTool sqt = new SMARTSQueryTool("C");
        for (int i = 0; i < PATTERNS.length; ++i) {
            sqt.setSmarts(PATTERNS[i]);
            boolean status = sqt.matches(atomContainer);
            if (!status) continue;
            fingerPrint.set(i, true);
        }
        return new BitSetFingerprint(fingerPrint);
    }

    @Override
    public Map<String, Integer> getRawFingerprint(IAtomContainer iAtomContainer) throws CDKException {
        throw new UnsupportedOperationException();
    }

    @Override
    @TestMethod(value="testGetSize")
    public int getSize() {
        return PATTERNS.length;
    }

    @Override
    public ICountFingerprint getCountFingerprint(IAtomContainer container) throws CDKException {
        throw new UnsupportedOperationException();
    }
}

