/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.tools.ILoggingTool;

@TestClass(value="org.openscience.cdk.tools.LoggingToolTest")
public class LoggingTool
implements ILoggingTool {
    private boolean doDebug = false;
    private boolean toSTDOUT = false;
    private Logger log4jLogger;
    private static ILoggingTool logger;
    private String classname;
    private int stackLength;
    public final int DEFAULT_STACK_LENGTH = 5;

    @TestMethod(value="testLoggingTool")
    public LoggingTool() {
        this(LoggingTool.class);
    }

    @TestMethod(value="testLoggingTool_Object")
    public LoggingTool(Object object) {
        this(object.getClass());
    }

    @TestMethod(value="testLoggingTool_Class")
    public LoggingTool(Class<?> classInst) {
        logger = this;
        this.stackLength = 5;
        this.classname = classInst.getName();
        try {
            this.log4jLogger = Logger.getLogger(this.classname);
        }
        catch (NoClassDefFoundError e) {
            this.toSTDOUT = true;
            logger.debug("Log4J class not found!");
        }
        catch (NullPointerException e) {
            this.toSTDOUT = true;
            logger.debug("Properties file not found!");
        }
        catch (Exception e) {
            this.toSTDOUT = true;
            logger.debug("Unknown error occured: ", e.getMessage());
        }
        this.doDebug = false;
        String strJvmVersion = System.getProperty("java.version");
        if (strJvmVersion.compareTo("1.2") >= 0) {
            try {
                if (System.getProperty("cdk.debugging", "false").equals("true")) {
                    this.doDebug = true;
                }
                if (System.getProperty("cdk.debug.stdout", "false").equals("true")) {
                    this.toSTDOUT = true;
                }
            }
            catch (Exception e) {
                logger.debug("guessed what happened: security exception thrown by applet runner");
                logger.debug("  therefore, do not debug");
            }
        }
    }

    @TestMethod(value="testConfigureLog4j")
    public static void configureLog4j() {
        LoggingTool localLogger = new LoggingTool(LoggingTool.class);
        try {
            PropertyConfigurator.configure(LoggingTool.class.getResource("/org/openscience/cdk/config/data/log4j.properties"));
        }
        catch (NullPointerException e) {
            localLogger.error("Properties file not found: ", e.getMessage());
            localLogger.debug(e);
        }
        catch (Exception e) {
            localLogger.error("Unknown error occured: ", e.getMessage());
            localLogger.debug(e);
        }
    }

    @Override
    @TestMethod(value="testDumpSystemProperties")
    public void dumpSystemProperties() {
        this.debug("os.name        : " + System.getProperty("os.name"));
        this.debug("os.version     : " + System.getProperty("os.version"));
        this.debug("os.arch        : " + System.getProperty("os.arch"));
        this.debug("java.version   : " + System.getProperty("java.version"));
        this.debug("java.vendor    : " + System.getProperty("java.vendor"));
    }

    @Override
    @TestMethod(value="testSetStackLength_int")
    public void setStackLength(int length) {
        this.stackLength = length;
    }

    @Override
    @TestMethod(value="testDumpClasspath")
    public void dumpClasspath() {
        this.debug("java.class.path: " + System.getProperty("java.class.path"));
    }

    @Override
    @TestMethod(value="testDebug_Object")
    public void debug(Object object) {
        if (this.doDebug) {
            if (object instanceof Throwable) {
                this.debugThrowable((Throwable)object);
            } else {
                this.debugString("" + object);
            }
        }
    }

    private void debugString(String string) {
        if (this.toSTDOUT) {
            this.printToSTDOUT("DEBUG", string);
        } else {
            this.log4jLogger.debug(string);
        }
    }

    @Override
    @TestMethod(value="testDebug_Object_int")
    public void debug(Object object, Object ... objects) {
        if (this.doDebug) {
            StringBuilder result = new StringBuilder();
            result.append(object.toString());
            for (Object obj : objects) {
                if (obj == null) {
                    result.append("null");
                    continue;
                }
                result.append(obj.toString());
            }
            this.debugString(result.toString());
        }
    }

    private void debugThrowable(Throwable problem) {
        if (problem != null) {
            if (problem instanceof Error) {
                this.debug("Error: ", problem.getMessage());
            } else {
                this.debug("Exception: ", problem.getMessage());
            }
            StringWriter stackTraceWriter = new StringWriter();
            problem.printStackTrace(new PrintWriter(stackTraceWriter));
            String trace = stackTraceWriter.toString();
            try {
                BufferedReader reader = new BufferedReader(new StringReader(trace));
                if (reader.ready()) {
                    String traceLine = reader.readLine();
                    for (int counter = 0; reader.ready() && traceLine != null && counter < this.stackLength; ++counter) {
                        this.debug(traceLine);
                        traceLine = reader.readLine();
                    }
                }
            }
            catch (Exception ioException) {
                this.error("Serious error in LoggingTool while printing exception stack trace: " + ioException.getMessage());
                logger.debug(ioException);
            }
            Throwable cause = problem.getCause();
            if (cause != null) {
                this.debug("Caused by: ");
                this.debugThrowable(cause);
            }
        }
    }

    @Override
    @TestMethod(value="testError_Object")
    public void error(Object object) {
        if (this.doDebug) {
            this.errorString("" + object);
        }
    }

    @Override
    @TestMethod(value="testError_Object_int")
    public void error(Object object, Object ... objects) {
        if (this.doDebug) {
            StringBuilder result = new StringBuilder();
            result.append(object.toString());
            for (Object obj : objects) {
                result.append(obj.toString());
            }
            this.errorString(result.toString());
        }
    }

    private void errorString(String string) {
        if (this.toSTDOUT) {
            this.printToSTDOUT("ERROR", string);
        } else {
            this.log4jLogger.error(string);
        }
    }

    @Override
    @TestMethod(value="testFatal_Object")
    public void fatal(Object object) {
        if (this.doDebug) {
            if (this.toSTDOUT) {
                this.printToSTDOUT("FATAL", object.toString());
            } else {
                this.log4jLogger.fatal("" + object.toString());
            }
        }
    }

    @Override
    @TestMethod(value="testInfo_Object")
    public void info(Object object) {
        if (this.doDebug) {
            this.infoString("" + object);
        }
    }

    @Override
    @TestMethod(value="testInfo_Object_int")
    public void info(Object object, Object ... objects) {
        if (this.doDebug) {
            StringBuilder result = new StringBuilder();
            result.append(object.toString());
            for (Object obj : objects) {
                result.append(obj.toString());
            }
            this.infoString(result.toString());
        }
    }

    private void infoString(String string) {
        if (this.toSTDOUT) {
            this.printToSTDOUT("INFO", string);
        } else {
            this.log4jLogger.info(string);
        }
    }

    @Override
    @TestMethod(value="testWarn_Object")
    public void warn(Object object) {
        if (this.doDebug) {
            this.warnString("" + object);
        }
    }

    private void warnString(String string) {
        if (this.toSTDOUT) {
            this.printToSTDOUT("WARN", string);
        } else {
            this.log4jLogger.warn(string);
        }
    }

    @Override
    @TestMethod(value="testWarn_Object_int")
    public void warn(Object object, Object ... objects) {
        if (this.doDebug) {
            StringBuilder result = new StringBuilder();
            result.append(object.toString());
            for (Object obj : objects) {
                result.append(obj.toString());
            }
            this.warnString(result.toString());
        }
    }

    @Override
    @TestMethod(value="testIsDebugEnabled")
    public boolean isDebugEnabled() {
        return this.doDebug;
    }

    private void printToSTDOUT(String level, String message) {
        System.out.print(this.classname);
        System.out.print(" ");
        System.out.print(level);
        System.out.print(": ");
        System.out.println(message);
    }

    @TestMethod(value="testCreate")
    public static ILoggingTool create(Class<?> sourceClass) {
        return new LoggingTool(sourceClass);
    }
}

