/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer;

import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.vecmath.Point2d;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;

@TestClass(value="org.openscience.cdk.renderer.BoundsCalculatorTest")
public class BoundsCalculator {
    @TestMethod(value="testCalculateBounds_IChemModel")
    public static Rectangle2D calculateBounds(IChemModel chemModel) {
        IMoleculeSet moleculeSet = chemModel.getMoleculeSet();
        IReactionSet reactionSet = chemModel.getReactionSet();
        Rectangle2D totalBounds = null;
        if (moleculeSet != null) {
            totalBounds = BoundsCalculator.calculateBounds(moleculeSet);
        }
        if (reactionSet != null) {
            totalBounds = totalBounds == null ? BoundsCalculator.calculateBounds(reactionSet) : totalBounds.createUnion(BoundsCalculator.calculateBounds(reactionSet));
        }
        return totalBounds;
    }

    @TestMethod(value="testCalculateBounds_IReactionSet")
    public static Rectangle2D calculateBounds(IReactionSet reactionSet) {
        Rectangle2D totalBounds = new Rectangle2D.Double();
        for (IReaction reaction : reactionSet.reactions()) {
            Rectangle2D reactionBounds = BoundsCalculator.calculateBounds(reaction);
            if (((RectangularShape)totalBounds).isEmpty()) {
                totalBounds = reactionBounds;
                continue;
            }
            Rectangle2D.union(totalBounds, reactionBounds, totalBounds);
        }
        return totalBounds;
    }

    @TestMethod(value="testCalculateBounds_IReaction")
    public static Rectangle2D calculateBounds(IReaction reaction) {
        IMoleculeSet reactants = reaction.getReactants();
        IMoleculeSet products = reaction.getProducts();
        if (reactants == null || products == null) {
            return null;
        }
        Rectangle2D reactantsBounds = BoundsCalculator.calculateBounds(reactants);
        return reactantsBounds.createUnion(BoundsCalculator.calculateBounds(products));
    }

    @TestMethod(value="testCalculateBounds_IMoleculeSet")
    public static Rectangle2D calculateBounds(IMoleculeSet moleculeSet) {
        Rectangle2D totalBounds = new Rectangle2D.Double();
        for (int i = 0; i < moleculeSet.getAtomContainerCount(); ++i) {
            IAtomContainer container = moleculeSet.getAtomContainer(i);
            Rectangle2D acBounds = BoundsCalculator.calculateBounds(container);
            if (((RectangularShape)totalBounds).isEmpty()) {
                totalBounds = acBounds;
                continue;
            }
            Rectangle2D.union(totalBounds, acBounds, totalBounds);
        }
        return totalBounds;
    }

    @TestMethod(value="testCalculateBounds_IAtomContainer")
    public static Rectangle2D calculateBounds(IAtomContainer atomContainer) {
        if (atomContainer.getAtomCount() == 0) {
            return new Rectangle2D.Double();
        }
        if (atomContainer.getAtomCount() == 1) {
            Point2d point = atomContainer.getAtom(0).getPoint2d();
            if (point == null) {
                throw new IllegalArgumentException("Cannot calculate bounds when 2D coordinates are missing.");
            }
            return new Rectangle2D.Double(point.x, point.y, 0.0, 0.0);
        }
        double xmin = Double.POSITIVE_INFINITY;
        double xmax = Double.NEGATIVE_INFINITY;
        double ymin = Double.POSITIVE_INFINITY;
        double ymax = Double.NEGATIVE_INFINITY;
        for (IAtom atom : atomContainer.atoms()) {
            Point2d point = atom.getPoint2d();
            if (point == null) {
                throw new IllegalArgumentException("Cannot calculate bounds when 2D coordinates are missing.");
            }
            xmin = Math.min(xmin, point.x);
            xmax = Math.max(xmax, point.x);
            ymin = Math.min(ymin, point.y);
            ymax = Math.max(ymax, point.y);
        }
        double width = xmax - xmin;
        double height = ymax - ymin;
        return new Rectangle2D.Double(xmin, ymin, width, height);
    }
}

