/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jniinchi;

import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.TimeoutException;
import net.sf.jnati.NativeCodeException;
import net.sf.jnati.deploy.NativeLibraryLoader;
import net.sf.jniinchi.INCHI_KEY_STATUS;
import net.sf.jniinchi.INCHI_OPTION;
import net.sf.jniinchi.JniInchiException;
import net.sf.jniinchi.JniInchiInput;
import net.sf.jniinchi.JniInchiInputInchi;
import net.sf.jniinchi.JniInchiOutput;
import net.sf.jniinchi.JniInchiOutputKey;
import net.sf.jniinchi.JniInchiOutputStructure;
import net.sf.jniinchi.LoadNativeLibraryException;
import org.apache.log4j.Logger;

public class JniInchiWrapper {
    private static final Logger LOG = Logger.getLogger(JniInchiWrapper.class);
    private static final String ID = "jniinchi";
    private static final String VERSION = "1.6";
    private static final int MAXVAL = 20;
    private static final int MAX_LOCK_TIMEOUT = 15;
    private static final boolean IS_WINDOWS = System.getProperty("os.name", "").toLowerCase().startsWith("windows");
    static final String flagChar = IS_WINDOWS ? "/" : "-";
    private static boolean libraryLoaded = false;
    private static JniInchiWrapper inchiWrapper;
    private boolean locked = false;

    public static synchronized void loadLibrary() throws LoadNativeLibraryException {
        if (!libraryLoaded) {
            try {
                NativeLibraryLoader.loadLibrary(ID, VERSION);
                JniInchiWrapper.checkNativeCodeVersion();
                libraryLoaded = true;
            }
            catch (NativeCodeException ex) {
                System.err.println();
                System.err.println("Error loading JNI InChI native code.");
                System.err.println("You may need to compile the native code for your platform.");
                System.err.println("See http://jni-inchi.sourceforge.net for instructions.");
                System.err.println();
                throw new LoadNativeLibraryException(ex);
            }
        }
    }

    private static void checkNativeCodeVersion() throws NativeCodeException {
        String nativeVersion;
        LOG.trace("Checking native code version");
        try {
            nativeVersion = JniInchiWrapper.LibInchiGetVersion();
        }
        catch (UnsatisfiedLinkError e) {
            LOG.error("Unable to get native code version", e);
            throw new NativeCodeException("Unable get native code version", e);
        }
        if (!VERSION.equals(nativeVersion)) {
            LOG.error("Native code version mismatch; expected 1.6, found " + nativeVersion);
            throw new NativeCodeException("JNI InChI native code version mismatch: expected 1.6, found " + nativeVersion);
        }
        LOG.trace("Expected native code version found: " + nativeVersion);
    }

    private static synchronized JniInchiWrapper getWrapper() throws LoadNativeLibraryException {
        if (inchiWrapper == null) {
            inchiWrapper = new JniInchiWrapper();
        }
        return inchiWrapper;
    }

    private JniInchiWrapper() throws LoadNativeLibraryException {
        JniInchiWrapper.loadLibrary();
        this.init();
    }

    protected static String checkOptions(List ops) throws JniInchiException {
        StringBuffer sbOptions = new StringBuffer();
        for (int i = 0; i < ops.size(); ++i) {
            Object op = ops.get(i);
            if (!(op instanceof INCHI_OPTION)) {
                throw new JniInchiException("Unrecognised InChI option");
            }
            sbOptions.append(flagChar + ((INCHI_OPTION)op).getName() + " ");
        }
        return sbOptions.toString();
    }

    protected static String checkOptions(String ops) throws JniInchiException {
        Map optionMap = INCHI_OPTION.getLowercaseMap();
        StringBuffer sbOptions = new StringBuffer();
        StringTokenizer tok = new StringTokenizer(ops);
        while (tok.hasMoreTokens()) {
            String op = tok.nextToken();
            if (op.startsWith("-") || op.startsWith("/")) {
                op = op.substring(1);
            }
            String lcop = op.toLowerCase();
            if (optionMap.keySet().contains(lcop)) {
                sbOptions.append(flagChar + optionMap.get(lcop) + " ");
                continue;
            }
            throw new JniInchiException("Unrecognised InChI option");
        }
        return sbOptions.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JniInchiOutput getInchi(JniInchiInput input) throws JniInchiException {
        JniInchiWrapper wrapper = JniInchiWrapper.getWrapper();
        try {
            wrapper.getLock();
        }
        catch (TimeoutException ex) {
            throw new JniInchiException(ex);
        }
        try {
            JniInchiOutput jniInchiOutput = wrapper.GetINCHI(input);
            return jniInchiOutput;
        }
        finally {
            wrapper.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JniInchiOutput getInchiFromInchi(JniInchiInputInchi input) throws JniInchiException {
        JniInchiWrapper wrapper = JniInchiWrapper.getWrapper();
        try {
            wrapper.getLock();
        }
        catch (TimeoutException ex) {
            throw new JniInchiException(ex);
        }
        try {
            JniInchiOutput jniInchiOutput = wrapper.GetINCHIfromINCHI(input.getInchi(), input.getOptions());
            return jniInchiOutput;
        }
        finally {
            wrapper.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JniInchiOutputStructure getStructureFromInchi(JniInchiInputInchi input) throws JniInchiException {
        JniInchiWrapper wrapper = JniInchiWrapper.getWrapper();
        try {
            wrapper.getLock();
        }
        catch (TimeoutException ex) {
            throw new JniInchiException(ex);
        }
        try {
            JniInchiOutputStructure jniInchiOutputStructure = wrapper.GetStructFromINCHI(input.getInchi(), input.getOptions());
            return jniInchiOutputStructure;
        }
        finally {
            wrapper.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JniInchiOutputKey getInChIKey(String inchi) throws JniInchiException {
        JniInchiWrapper wrapper = JniInchiWrapper.getWrapper();
        try {
            wrapper.getLock();
        }
        catch (TimeoutException ex) {
            throw new JniInchiException(ex);
        }
        try {
            JniInchiOutputKey jniInchiOutputKey = wrapper.GetINCHIKeyFromINCHI(inchi);
            return jniInchiOutputKey;
        }
        finally {
            wrapper.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static INCHI_KEY_STATUS checkInChIKey(String key) throws JniInchiException {
        JniInchiWrapper wrapper = JniInchiWrapper.getWrapper();
        try {
            wrapper.getLock();
        }
        catch (TimeoutException ex) {
            throw new JniInchiException(ex);
        }
        try {
            int ret = wrapper.CheckINCHIKey(key);
            INCHI_KEY_STATUS retStatus = INCHI_KEY_STATUS.getValue(ret);
            if (retStatus == null) {
                throw new JniInchiException("Unknown return status: " + ret);
            }
            INCHI_KEY_STATUS iNCHI_KEY_STATUS = retStatus;
            return iNCHI_KEY_STATUS;
        }
        finally {
            wrapper.releaseLock();
        }
    }

    private synchronized void getLock() throws TimeoutException {
        long timeout = System.currentTimeMillis() + 15000L;
        while (this.locked) {
            if (timeout >= System.currentTimeMillis()) continue;
            throw new TimeoutException("Unable to get lock");
        }
        this.locked = true;
    }

    private void releaseLock() {
        this.locked = false;
    }

    protected static native String LibInchiGetVersion();

    private native void init();

    private native JniInchiOutput GetINCHI(JniInchiInput var1);

    private native JniInchiOutput GetINCHIfromINCHI(String var1, String var2);

    private native JniInchiOutputStructure GetStructFromINCHI(String var1, String var2);

    private native JniInchiOutputKey GetINCHIKeyFromINCHI(String var1);

    private native int CheckINCHIKey(String var1);
}

