/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import javax.vecmath.Point2d;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.OvalElement;
import org.openscience.cdk.renderer.elements.RectangleElement;
import org.openscience.cdk.renderer.generators.BasicAtomGenerator;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.generators.IGeneratorParameter;
import org.openscience.cdk.renderer.generators.parameter.AbstractGeneratorParameter;
import org.openscience.cdk.renderer.selection.IChemObjectSelection;
import org.openscience.cdk.renderer.selection.IncrementalSelection;

public class SelectAtomGenerator
implements IGenerator<IAtomContainer> {
    private IGeneratorParameter<BasicAtomGenerator.Shape> selectionShape = new SelectionShape();
    private SelectionRadius selectionRadius = new SelectionRadius();
    private SelectionAtomColor selectionAtomColor = new SelectionAtomColor();
    private boolean autoUpdateSelection = true;

    @Override
    public IRenderingElement generate(IAtomContainer ac, RendererModel model) {
        IncrementalSelection sel;
        Color selectionColor = (Color)model.getParameter(SelectionAtomColor.class).getValue();
        BasicAtomGenerator.Shape shape = this.selectionShape.getValue();
        IChemObjectSelection selection = model.getSelection();
        ElementGroup selectionElements = new ElementGroup();
        if (selection == null) {
            return selectionElements;
        }
        if (this.autoUpdateSelection || selection.isFilled()) {
            double r = (Double)model.getParameter(SelectionRadius.class).getValue() / (Double)model.getParameter(BasicSceneGenerator.Scale.class).getValue();
            double d = 2.0 * r;
            IAtomContainer selectedAC = selection.getConnectedAtomContainer();
            if (selectedAC != null) {
                for (IAtom atom : selectedAC.atoms()) {
                    IRenderingElement element;
                    Point2d p = atom.getPoint2d();
                    switch (shape) {
                        case SQUARE: {
                            element = new RectangleElement(p.x - r, p.y - r, d, d, true, selectionColor);
                            break;
                        }
                        default: {
                            element = new OvalElement(p.x, p.y, d, false, selectionColor);
                        }
                    }
                    selectionElements.add(element);
                }
            }
        }
        if (selection instanceof IncrementalSelection && !(sel = (IncrementalSelection)selection).isFinished()) {
            selectionElements.add(sel.generate(selectionColor));
        }
        return selectionElements;
    }

    @Override
    public List<IGeneratorParameter<?>> getParameters() {
        return Arrays.asList(this.selectionRadius, this.selectionShape, this.selectionAtomColor);
    }

    public static class SelectionAtomColor
    extends AbstractGeneratorParameter<Color> {
        @Override
        public Color getDefault() {
            return Color.LIGHT_GRAY;
        }
    }

    public static class SelectionRadius
    extends AbstractGeneratorParameter<Double> {
        @Override
        public Double getDefault() {
            return 2.0;
        }
    }

    public static class SelectionShape
    extends AbstractGeneratorParameter<BasicAtomGenerator.Shape> {
        @Override
        public BasicAtomGenerator.Shape getDefault() {
            return BasicAtomGenerator.Shape.SQUARE;
        }
    }
}

