/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import javax.vecmath.Point2d;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.LineElement;
import org.openscience.cdk.renderer.elements.OvalElement;
import org.openscience.cdk.renderer.generators.BasicBondGenerator;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.generators.IGeneratorParameter;
import org.openscience.cdk.renderer.generators.parameter.AbstractGeneratorParameter;

public class ExternalHighlightGenerator
implements IGenerator<IAtomContainer> {
    private ExternalHighlightDistance externalHighlightDistance = new ExternalHighlightDistance();

    @Override
    public IRenderingElement generate(IAtomContainer ac, RendererModel model) {
        ElementGroup group = new ElementGroup();
        ac = model.getExternalSelectedPart();
        if (ac == null) {
            return group;
        }
        for (IAtom atom : ac.atoms()) {
            group.add(this.generate(atom, model));
        }
        for (IBond bond : ac.bonds()) {
            group.add(this.generate(bond, model));
        }
        return group;
    }

    @Override
    public IRenderingElement generate(IAtom atom, RendererModel model) {
        Point2d p = atom.getPoint2d();
        double r = (Double)model.getParameter(ExternalHighlightDistance.class).getValue() / (Double)model.getParameter(BasicSceneGenerator.Scale.class).getValue();
        return new OvalElement(p.x, p.y, r, (Color)model.getParameter(RendererModel.ExternalHighlightColor.class).getValue());
    }

    @Override
    public IRenderingElement generate(IBond bond, RendererModel model) {
        Point2d p1 = bond.getAtom(0).getPoint2d();
        Point2d p2 = bond.getAtom(1).getPoint2d();
        double w = (Double)model.getParameter(BasicBondGenerator.BondWidth.class).getValue() / (Double)model.getParameter(BasicSceneGenerator.Scale.class).getValue();
        return new LineElement(p1.x, p1.y, p2.x, p2.y, w, (Color)model.getParameter(RendererModel.ExternalHighlightColor.class).getValue());
    }

    @Override
    public List<IGeneratorParameter<?>> getParameters() {
        return Arrays.asList(this.externalHighlightDistance);
    }

    public static class ExternalHighlightDistance
    extends AbstractGeneratorParameter<Double> {
        @Override
        public Double getDefault() {
            return 8.0;
        }
    }
}

