/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.vecmath.Point2d;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.renderer.AbstractRenderer;
import org.openscience.cdk.renderer.AtomContainerRenderer;
import org.openscience.cdk.renderer.AverageBondLengthCalculator;
import org.openscience.cdk.renderer.BoundsCalculator;
import org.openscience.cdk.renderer.IRenderer;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.font.IFontManager;
import org.openscience.cdk.renderer.generators.BasicBondGenerator;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.visitor.IDrawVisitor;

public class MoleculeSetRenderer
extends AbstractRenderer<IMoleculeSet>
implements IRenderer<IMoleculeSet> {
    private IRenderer<IAtomContainer> atomContainerRenderer;

    public MoleculeSetRenderer(List<IGenerator<IAtomContainer>> generators, IFontManager fontManager) {
        this.fontManager = fontManager;
        this.atomContainerRenderer = new AtomContainerRenderer(generators, fontManager);
        this.setup();
    }

    @Override
    public void setup(IMoleculeSet moleculeSet, Rectangle screen) {
        this.setScale(moleculeSet);
        Rectangle2D bounds = BoundsCalculator.calculateBounds(moleculeSet);
        if (bounds != null) {
            this.modelCenter = new Point2d(bounds.getCenterX(), bounds.getCenterY());
        }
        this.drawCenter = new Point2d(screen.getCenterX(), screen.getCenterY());
        this.setup();
    }

    @Override
    public Rectangle shift(Rectangle screenBounds, Rectangle diagramBounds) {
        int screenMaxX = screenBounds.x + screenBounds.width;
        int screenMaxY = screenBounds.y + screenBounds.height;
        int diagramMaxX = diagramBounds.x + diagramBounds.width;
        int diagramMaxY = diagramBounds.y + diagramBounds.height;
        int leftOverlap = screenBounds.x - diagramBounds.x;
        int rightOverlap = diagramMaxX - screenMaxX;
        int topOverlap = screenBounds.y - diagramBounds.y;
        int bottomOverlap = diagramMaxY - screenMaxY;
        int dx = 0;
        int dy = 0;
        int w = screenBounds.width;
        int h = screenBounds.height;
        if (leftOverlap > 0) {
            dx = leftOverlap;
        }
        if (rightOverlap > 0) {
            w += rightOverlap;
        }
        if (topOverlap > 0) {
            dy = topOverlap;
        }
        if (bottomOverlap > 0) {
            h += bottomOverlap;
        }
        if (dx != 0 || dy != 0) {
            this.shiftDrawCenter(dx, dy);
        }
        return new Rectangle(dx, dy, w, h);
    }

    @Override
    public void setScale(IMoleculeSet moleculeSet) {
        double bondLength = AverageBondLengthCalculator.calculateAverageBondLength(moleculeSet);
        double scale = this.calculateScaleForBondLength(bondLength);
        this.rendererModel.getParameter(BasicSceneGenerator.Scale.class).setValue(scale);
    }

    @Override
    public Rectangle paint(IMoleculeSet moleculeSet, IDrawVisitor drawVisitor) {
        Rectangle2D totalBounds = new Rectangle2D.Double();
        for (IAtomContainer molecule : moleculeSet.molecules()) {
            Rectangle2D modelBounds = BoundsCalculator.calculateBounds(molecule);
            if (totalBounds == null) {
                totalBounds = modelBounds;
                continue;
            }
            totalBounds = ((Rectangle2D)totalBounds).createUnion(modelBounds);
        }
        this.setupTransformNatural(totalBounds);
        ElementGroup diagram = new ElementGroup();
        for (IAtomContainer molecule : moleculeSet.molecules()) {
            diagram.add(this.atomContainerRenderer.generateDiagram(molecule));
        }
        this.paint(drawVisitor, diagram);
        return this.convertToDiagramBounds(totalBounds);
    }

    @Override
    public void paint(IMoleculeSet molecules, IDrawVisitor drawVisitor, Rectangle2D bounds, boolean resetCenter) {
        Rectangle2D totalBounds = null;
        for (IAtomContainer molecule : molecules.molecules()) {
            Rectangle2D modelBounds = BoundsCalculator.calculateBounds(molecule);
            if (totalBounds == null) {
                totalBounds = modelBounds;
                continue;
            }
            totalBounds = totalBounds.createUnion(modelBounds);
        }
        this.setupTransformToFit(bounds, totalBounds, AverageBondLengthCalculator.calculateAverageBondLength(molecules), resetCenter);
        ElementGroup diagram = new ElementGroup();
        for (IAtomContainer molecule : molecules.molecules()) {
            diagram.add(this.atomContainerRenderer.generateDiagram(molecule));
        }
        this.paint(drawVisitor, diagram);
    }

    @Override
    public Rectangle calculateDiagramBounds(IMoleculeSet moleculeSet) {
        return this.calculateScreenBounds(BoundsCalculator.calculateBounds(moleculeSet));
    }

    @Override
    public double calculateScaleForBondLength(double modelBondLength) {
        if (Double.isNaN(modelBondLength) || modelBondLength == 0.0) {
            return this.rendererModel.getParameter(BasicSceneGenerator.Scale.class).getDefault();
        }
        return (Double)this.rendererModel.getParameter(BasicBondGenerator.BondLength.class).getValue() / modelBondLength;
    }

    @Override
    public List<IGenerator<IMoleculeSet>> getGenerators() {
        return null;
    }
}

