/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller.edit;

import java.util.Set;
import javax.vecmath.Point2d;
import org.openscience.cdk.controller.Changed;
import org.openscience.cdk.controller.edit.AbstractEdit;
import org.openscience.cdk.controller.edit.IEdit;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;

public class CreateBond
extends AbstractEdit
implements IEdit {
    Point2d first;
    Point2d second;
    IAtom firstAtom;
    IAtom secondAtom;
    IBond bond;

    public static CreateBond edit(Point2d first, Point2d second) {
        return new CreateBond(first, second);
    }

    private CreateBond(Point2d first, Point2d second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public void redo() {
        if (this.firstAtom == null && this.secondAtom == null && this.bond == null) {
            this.firstAtom = (IAtom)this.model.getBuilder().newInstance(IAtom.class, new Object[]{"C", this.first});
            this.secondAtom = (IAtom)this.model.getBuilder().newInstance(IAtom.class, new Object[]{"C", this.second});
            this.bond = (IBond)this.model.getBuilder().newInstance(IBond.class, new Object[]{this.firstAtom, this.secondAtom});
        }
        this.model.addAtom(this.firstAtom);
        this.model.addAtom(this.secondAtom);
        this.model.addBond(this.bond);
        this.updateHydrogenCount(this.firstAtom, this.secondAtom);
    }

    @Override
    public void undo() {
        this.model.removeBond(this.bond);
        this.model.removeAtom(this.firstAtom);
        this.model.removeAtom(this.secondAtom);
    }

    @Override
    public Set<Changed> getTypeOfChanges() {
        return CreateBond.changed(Changed.Structure);
    }
}

