/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism.mcss;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.openscience.cdk.isomorphism.mcss.RMap;
import org.openscience.cdk.isomorphism.mcss.RNode;

public class RGraph {
    List<RNode> graph = new ArrayList<RNode>();
    int maxIteration = -1;
    int firstGraphSize = 0;
    int secondGraphSize = 0;
    BitSet c1 = null;
    BitSet c2 = null;
    List<BitSet> solutionList = new ArrayList<BitSet>();
    boolean findAllMap = false;
    boolean findAllStructure = true;
    boolean stop = false;
    int nbIteration = 0;
    BitSet graphBitSet = new BitSet();
    private long timeout = -1L;
    private long start;

    public int getFirstGraphSize() {
        return this.firstGraphSize;
    }

    public int getSecondGraphSize() {
        return this.secondGraphSize;
    }

    public void setFirstGraphSize(int n1) {
        this.firstGraphSize = n1;
    }

    public void setSecondGraphSize(int n2) {
        this.secondGraphSize = n2;
    }

    public void clear() {
        this.graph.clear();
        this.graphBitSet.clear();
    }

    public List<RNode> getGraph() {
        return this.graph;
    }

    public void addNode(RNode newNode) {
        this.graph.add(newNode);
        this.graphBitSet.set(this.graph.size() - 1);
    }

    public void parse(BitSet c1, BitSet c2, boolean findAllStructure, boolean findAllMap) {
        this.solutionList.clear();
        BitSet b = this.buildB(c1, c2);
        this.setAllStructure(findAllStructure);
        this.setAllMap(findAllMap);
        this.parseRec(new BitSet(b.size()), b, new BitSet(b.size()));
    }

    private void parseRec(BitSet traversed, BitSet extension, BitSet forbidden) {
        BitSet newTraversed = null;
        BitSet newExtension = null;
        BitSet newForbidden = null;
        BitSet potentialNode = null;
        if (this.timeout > -1L && System.currentTimeMillis() - this.start > this.timeout) {
            this.stop = true;
        }
        if (extension.isEmpty()) {
            this.solution(traversed);
        } else {
            potentialNode = (BitSet)this.graphBitSet.clone();
            potentialNode.andNot(forbidden);
            potentialNode.or(traversed);
            if (this.mustContinue(potentialNode)) {
                ++this.nbIteration;
                int x = extension.nextSetBit(0);
                while (x >= 0 && !this.stop) {
                    newForbidden = (BitSet)forbidden.clone();
                    newForbidden.or(this.graph.get((int)x).forbidden);
                    if (traversed.isEmpty()) {
                        newExtension = (BitSet)this.graph.get((int)x).extension.clone();
                    } else {
                        newExtension = (BitSet)extension.clone();
                        newExtension.or(this.graph.get((int)x).extension);
                    }
                    newExtension.andNot(newForbidden);
                    newTraversed = (BitSet)traversed.clone();
                    newTraversed.set(x);
                    forbidden.set(x);
                    this.parseRec(newTraversed, newExtension, newForbidden);
                    x = extension.nextSetBit(x + 1);
                }
            }
        }
    }

    private void solution(BitSet traversed) {
        boolean included = false;
        BitSet projG1 = this.projectG1(traversed);
        BitSet projG2 = this.projectG2(traversed);
        if (this.isContainedIn(this.c1, projG1) && this.isContainedIn(this.c2, projG2)) {
            ListIterator<BitSet> i = this.solutionList.listIterator();
            while (i.hasNext() && !included) {
                BitSet sol = (BitSet)i.next();
                if (!sol.equals(traversed)) {
                    if (this.findAllMap && (projG1.equals(this.projectG1(sol)) || projG2.equals(this.projectG2(sol)))) continue;
                    if (this.isContainedIn(projG1, this.projectG1(sol)) || this.isContainedIn(projG2, this.projectG2(sol))) {
                        included = true;
                        continue;
                    }
                    if (!this.isContainedIn(this.projectG1(sol), projG1) && !this.isContainedIn(this.projectG2(sol), projG2)) continue;
                    i.remove();
                    continue;
                }
                included = true;
            }
            if (!included) {
                this.solutionList.add(traversed);
            }
            if (!this.findAllStructure) {
                this.stop = true;
            }
        }
    }

    private boolean mustContinue(BitSet potentialNode) {
        boolean result = true;
        boolean cancel = false;
        BitSet projG1 = this.projectG1(potentialNode);
        BitSet projG2 = this.projectG2(potentialNode);
        if (this.maxIteration != -1 && this.nbIteration >= this.maxIteration) {
            return false;
        }
        if (!this.isContainedIn(this.c1, projG1) || !this.isContainedIn(this.c2, projG2)) {
            return false;
        }
        Iterator<BitSet> i = this.solutionList.iterator();
        while (i.hasNext() && !cancel) {
            BitSet sol = i.next();
            if (this.findAllMap && (projG1.equals(this.projectG1(sol)) || projG2.equals(this.projectG2(sol))) || !this.isContainedIn(projG1, this.projectG1(sol)) && !this.isContainedIn(projG2, this.projectG2(sol))) continue;
            result = false;
            cancel = true;
        }
        return result;
    }

    private BitSet buildB(BitSet c1, BitSet c2) {
        this.c1 = c1;
        this.c2 = c2;
        BitSet bs = new BitSet();
        for (RNode rn : this.graph) {
            if (!c1.get(rn.rMap.id1) && !c1.isEmpty() || !c2.get(rn.rMap.id2) && !c2.isEmpty()) continue;
            bs.set(this.graph.indexOf(rn));
        }
        return bs;
    }

    public List<BitSet> getSolutions() {
        return this.solutionList;
    }

    public List<RMap> bitSetToRMap(BitSet set) {
        ArrayList<RMap> rMapList = new ArrayList<RMap>();
        int x = set.nextSetBit(0);
        while (x >= 0) {
            RNode xNode = this.graph.get(x);
            rMapList.add(xNode.rMap);
            x = set.nextSetBit(x + 1);
        }
        return rMapList;
    }

    public void setAllStructure(boolean findAllStructure) {
        this.findAllStructure = findAllStructure;
    }

    public void setAllMap(boolean findAllMap) {
        this.findAllMap = findAllMap;
    }

    public void setMaxIteration(int it) {
        this.maxIteration = it;
    }

    public String toString() {
        String message = "";
        int j = 0;
        for (RNode rn : this.graph) {
            message = message + "-------------\nRNode " + j + "\n" + rn.toString() + "\n";
            ++j;
        }
        return message;
    }

    public BitSet projectG1(BitSet set) {
        BitSet projection = new BitSet(this.firstGraphSize);
        RNode xNode = null;
        int x = set.nextSetBit(0);
        while (x >= 0) {
            xNode = this.graph.get(x);
            projection.set(xNode.rMap.id1);
            x = set.nextSetBit(x + 1);
        }
        return projection;
    }

    public BitSet projectG2(BitSet set) {
        BitSet projection = new BitSet(this.secondGraphSize);
        RNode xNode = null;
        int x = set.nextSetBit(0);
        while (x >= 0) {
            xNode = this.graph.get(x);
            projection.set(xNode.rMap.id2);
            x = set.nextSetBit(x + 1);
        }
        return projection;
    }

    private boolean isContainedIn(BitSet A, BitSet B) {
        boolean result = false;
        if (A.isEmpty()) {
            return true;
        }
        BitSet setA = (BitSet)A.clone();
        setA.and(B);
        if (setA.equals(A)) {
            result = true;
        }
        return result;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setStart(long start) {
        this.start = start;
    }
}

