/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.config.atomtypes;

import java.util.Hashtable;
import java.util.Map;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

@TestClass(value="org.openscience.cdk.config.atomtypes.OWLAtomTypeMappingHandlerTest")
public class OWLAtomTypeMappingHandler
extends DefaultHandler {
    private final String NS_ATOMTYPE_MAPPING = "http://cdk.sf.net/ontologies/atomtypemappings#";
    private final String NS_OWL = "http://www.w3.org/2002/07/owl#";
    private Map<String, String> atomTypeMappings;
    private String fromType;
    private String toType;

    @TestMethod(value="testGetAtomTypeMappings")
    public Map<String, String> getAtomTypeMappings() {
        return this.atomTypeMappings;
    }

    @Override
    @TestMethod(value="testStartDocument")
    public void startDocument() {
        this.atomTypeMappings = new Hashtable<String, String>();
    }

    @Override
    @TestMethod(value="testEndElement_String_String_String")
    public void endElement(String uri, String local, String raw) {
        if ("http://www.w3.org/2002/07/owl#".equals(uri)) {
            this.endAtomTypeElement(local);
        }
    }

    private void endAtomTypeElement(String local) {
        if ("Thing".equals(local) && this.toType != null && this.fromType != null) {
            this.atomTypeMappings.put(this.fromType, this.toType);
        }
    }

    @Override
    @TestMethod(value="testStartElement_String_String_String_Attributes")
    public void startElement(String uri, String local, String raw, Attributes atts) {
        if ("http://www.w3.org/2002/07/owl#".equals(uri)) {
            this.startOWLElement(local, atts);
        } else if ("http://cdk.sf.net/ontologies/atomtypemappings#".equals(uri)) {
            this.startAtomTypeMappingElement(local, atts);
        }
    }

    private void startOWLElement(String local, Attributes atts) {
        if ("Thing".equals(local)) {
            this.toType = null;
            this.fromType = atts.getValue("rdf:about");
            this.fromType = this.fromType.substring(this.fromType.indexOf(35) + 1);
        }
    }

    private void startAtomTypeMappingElement(String local, Attributes atts) {
        if ("mapsToType".equals(local) || "equivalentAsType".equals(local)) {
            this.toType = atts.getValue("rdf:resource");
            this.toType = this.toType.substring(this.toType.indexOf(35) + 1);
        }
    }

    @Override
    @TestMethod(value="testCharacters_arraychar_int_int")
    public void characters(char[] chars, int start, int length) {
    }
}

