/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller.undoredo;

import java.util.Map;
import java.util.Set;
import org.openscience.cdk.controller.undoredo.IUndoRedoable;
import org.openscience.cdk.interfaces.IAtom;

public class ChangeHydrogenCountEdit
implements IUndoRedoable {
    private static final long serialVersionUID = 1237756549190508501L;
    private Map<IAtom, Integer[]> atomHydrogenCountsMap;
    private String type;

    public ChangeHydrogenCountEdit(Map<IAtom, Integer[]> atomHydrogenCountsMap, String type) {
        this.atomHydrogenCountsMap = atomHydrogenCountsMap;
        this.type = type;
    }

    @Override
    public void redo() {
        Set<IAtom> keys = this.atomHydrogenCountsMap.keySet();
        for (IAtom atom : keys) {
            Integer[] counts = this.atomHydrogenCountsMap.get(atom);
            atom.setNotification(false);
            atom.setImplicitHydrogenCount(counts[0]);
            atom.setNotification(true);
        }
    }

    @Override
    public void undo() {
        Set<IAtom> keys = this.atomHydrogenCountsMap.keySet();
        for (IAtom atom : keys) {
            Integer[] counts = this.atomHydrogenCountsMap.get(atom);
            atom.setImplicitHydrogenCount(counts[1]);
        }
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    public String getPresentationName() {
        return this.type;
    }
}

