/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller.undoredo;

import java.io.IOException;
import java.io.OptionalDataException;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.controller.IChemModelRelay;
import org.openscience.cdk.controller.undoredo.IUndoRedoable;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IChemObjectBuilder;

public class ChangeAtomSymbolEdit
implements IUndoRedoable {
    private static final long serialVersionUID = 779682083223003185L;
    private IAtom atom;
    private String formerSymbol;
    private String symbol;
    private String type;
    private IChemModelRelay chemModelRelay = null;

    public ChangeAtomSymbolEdit(IAtom atomInRange, String formerSymbol, String symbol, String type, IChemModelRelay chemModelRelay) {
        this.atom = atomInRange;
        this.formerSymbol = formerSymbol;
        this.symbol = symbol;
        this.type = type;
        this.chemModelRelay = chemModelRelay;
    }

    @Override
    public void redo() throws CannotRedoException {
        this.atom.setSymbol(this.symbol);
        try {
            IsotopeFactory.getInstance((IChemObjectBuilder)this.atom.getBuilder()).configure(this.atom);
            this.chemModelRelay.updateAtom(this.atom);
        }
        catch (OptionalDataException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        this.atom.setSymbol(this.formerSymbol);
        this.chemModelRelay.updateAtom(this.atom);
        try {
            IsotopeFactory.getInstance((IChemObjectBuilder)this.atom.getBuilder()).configure(this.atom);
        }
        catch (OptionalDataException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    public String getPresentationName() {
        return this.type;
    }
}

