/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.PathTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@TestClass(value="org.openscience.cdk.qsar.descriptors.molecular.WeightedPathDescriptorTest")
public class WeightedPathDescriptor
implements IMolecularDescriptor {
    private static final String[] names = new String[]{"WTPT-1", "WTPT-2", "WTPT-3", "WTPT-4", "WTPT-5"};

    @Override
    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#weightedPath", this.getClass().getName(), "$Id$", "The Chemistry Development Kit");
    }

    @Override
    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
    }

    @Override
    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        return null;
    }

    @Override
    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return names;
    }

    @Override
    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        return null;
    }

    @Override
    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        return null;
    }

    @Override
    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtomContainer container) {
        int j;
        IAtomContainer local = AtomContainerManipulator.removeHydrogens(container);
        int natom = local.getAtomCount();
        DoubleArrayResult retval = new DoubleArrayResult();
        ArrayList<List<IAtom>> pathList = new ArrayList<List<IAtom>>();
        for (int i = 0; i < natom - 1; ++i) {
            IAtom a = local.getAtom(i);
            for (int j2 = i + 1; j2 < natom; ++j2) {
                IAtom b = local.getAtom(j2);
                pathList.addAll(PathTools.getAllPaths(local, a, b));
            }
        }
        double[] pathWts = this.getPathWeights(pathList, local);
        double mid = 0.0;
        for (double pathWt3 : pathWts) {
            mid += pathWt3;
        }
        retval.add(mid += (double)natom);
        retval.add(mid / (double)natom);
        pathList.clear();
        int count = 0;
        for (int i = 0; i < natom; ++i) {
            IAtom a = local.getAtom(i);
            if (a.getSymbol().equalsIgnoreCase("C")) continue;
            ++count;
            for (int j3 = 0; j3 < natom; ++j3) {
                IAtom b = local.getAtom(j3);
                if (a.equals(b)) continue;
                pathList.addAll(PathTools.getAllPaths(local, a, b));
            }
        }
        pathWts = this.getPathWeights(pathList, local);
        mid = 0.0;
        for (double pathWt2 : pathWts) {
            mid += pathWt2;
        }
        retval.add(mid += (double)count);
        pathList.clear();
        count = 0;
        for (int i = 0; i < natom; ++i) {
            IAtom a = local.getAtom(i);
            if (!a.getSymbol().equalsIgnoreCase("O")) continue;
            ++count;
            for (j = 0; j < natom; ++j) {
                IAtom b = local.getAtom(j);
                if (a.equals(b)) continue;
                pathList.addAll(PathTools.getAllPaths(local, a, b));
            }
        }
        pathWts = this.getPathWeights(pathList, local);
        mid = 0.0;
        for (double pathWt1 : pathWts) {
            mid += pathWt1;
        }
        retval.add(mid += (double)count);
        pathList.clear();
        count = 0;
        for (int i = 0; i < natom; ++i) {
            IAtom a = local.getAtom(i);
            if (!a.getSymbol().equalsIgnoreCase("N")) continue;
            ++count;
            for (j = 0; j < natom; ++j) {
                IAtom b = local.getAtom(j);
                if (a.equals(b)) continue;
                pathList.addAll(PathTools.getAllPaths(local, a, b));
            }
        }
        pathWts = this.getPathWeights(pathList, local);
        mid = 0.0;
        for (double pathWt : pathWts) {
            mid += pathWt;
        }
        retval.add(mid += (double)count);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), retval, this.getDescriptorNames());
    }

    @Override
    @TestMethod(value="testGetDescriptorResultType")
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(5);
    }

    private double[] getPathWeights(List pathList, IAtomContainer atomContainer) {
        double[] pathWts = new double[pathList.size()];
        for (int i = 0; i < pathList.size(); ++i) {
            List p = (List)pathList.get(i);
            pathWts[i] = 1.0;
            for (int j = 0; j < p.size() - 1; ++j) {
                IAtom a = (IAtom)p.get(j);
                IAtom b = (IAtom)p.get(j + 1);
                int n1 = atomContainer.getConnectedAtomsList(a).size();
                int n2 = atomContainer.getConnectedAtomsList(b).size();
                int n = i;
                pathWts[n] = pathWts[n] / Math.sqrt(n1 * n2);
            }
        }
        return pathWts;
    }
}

