/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import org.openscience.cdk.MoleculeSet;
import org.openscience.cdk.Reaction;
import org.openscience.cdk.ReactionSet;
import org.openscience.cdk.applications.jchempaint.JChemPaintModel;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.geometry.Projector;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.layout.StructureDiagramGenerator;
import org.openscience.cdk.tools.LoggingTool;
import org.openscience.cdk.tools.manipulator.ChemModelManipulator;

public class CreateCoordinatesForFileDialog
extends JInternalFrame {
    private static final long serialVersionUID = 6717348756533287248L;
    private IChemModel chemModel;
    private HashMap renderingCoordinates;
    private JRadioButton generate2DButton;
    private JRadioButton from3DButton;
    private LoggingTool logger = null;

    public CreateCoordinatesForFileDialog(IChemModel model, HashMap renderingCoordinates) {
        super("Coordinate Creation", true, true, true, true);
        this.chemModel = model;
        this.renderingCoordinates = renderingCoordinates;
        this.logger = new LoggingTool((Object)this);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel radioPanel = new JPanel();
        radioPanel.setLayout(new GridLayout(0, 1));
        ButtonGroup group = new ButtonGroup();
        this.generate2DButton = new JRadioButton("create with layout algorithm");
        group.add(this.generate2DButton);
        radioPanel.add(this.generate2DButton);
        if (GeometryTools.has3DCoordinates((IAtomContainer)ChemModelManipulator.getAllInOneContainer((IChemModel)this.chemModel))) {
            this.from3DButton = new JRadioButton("create from 3D coordinates in file");
            group.add(this.from3DButton);
            radioPanel.add(this.from3DButton);
            this.from3DButton.setSelected(true);
        } else {
            this.generate2DButton.setSelected(true);
        }
        JPanel optionPane = new JPanel();
        optionPane.setLayout(new GridLayout(0, 1));
        JLabel label = new JLabel("The file does not contain 2D Coordinates or only some. Should I create those?");
        optionPane.add(label);
        optionPane.add(radioPanel);
        JButton cancelButton = new JButton("Cancel");
        JButton createButton = new JButton("Create");
        cancelButton.addActionListener(new CancelAction());
        createButton.addActionListener(new CreateAction());
        this.getRootPane().setDefaultButton(createButton);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 0));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(createButton);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(cancelButton);
        contentPane.add((Component)optionPane, "Center");
        contentPane.add((Component)buttonPane, "South");
        this.pack();
        this.setVisible(true);
    }

    public void closeFrame() {
        this.dispose();
    }

    class CreateAction
    extends AbstractAction {
        private static final long serialVersionUID = 7041050310635125218L;
        StructureDiagramGenerator diagramGenerator = new StructureDiagramGenerator();

        CreateAction() {
            super("Create");
        }

        public void actionPerformed(ActionEvent event) {
            if (CreateCoordinatesForFileDialog.this.from3DButton != null && CreateCoordinatesForFileDialog.this.from3DButton.isSelected()) {
                Projector.project2D((IAtomContainer)ChemModelManipulator.getAllInOneContainer((IChemModel)CreateCoordinatesForFileDialog.this.chemModel), (HashMap)CreateCoordinatesForFileDialog.this.renderingCoordinates);
            } else {
                IReactionSet reactionSet;
                IMoleculeSet som = CreateCoordinatesForFileDialog.this.chemModel.getMoleculeSet();
                if (som != null) {
                    CreateCoordinatesForFileDialog.this.logger.debug((Object)"no mols in som: ", som.getMoleculeCount());
                    MoleculeSet newsom = new MoleculeSet();
                    Iterator mols = som.molecules();
                    while (mols.hasNext()) {
                        newsom.addMolecule(this.relayoutMolecule((IMolecule)mols.next()));
                    }
                    CreateCoordinatesForFileDialog.this.chemModel.setMoleculeSet((IMoleculeSet)newsom);
                }
                if ((reactionSet = CreateCoordinatesForFileDialog.this.chemModel.getReactionSet()) != null) {
                    ReactionSet newSet = new ReactionSet();
                    Iterator reactionIter = reactionSet.reactions();
                    while (reactionIter.hasNext()) {
                        IReaction reaction = (IReaction)reactionIter.next();
                        Reaction newReaction = new Reaction();
                        Iterator reactants = reaction.getReactants().molecules();
                        while (reactants.hasNext()) {
                            newReaction.addReactant(this.relayoutMolecule((IMolecule)reactants.next()));
                        }
                        Iterator products = reaction.getProducts().molecules();
                        while (products.hasNext()) {
                            newReaction.addProduct(this.relayoutMolecule((IMolecule)products.next()));
                        }
                        newSet.addReaction((IReaction)newReaction);
                    }
                    CreateCoordinatesForFileDialog.this.chemModel.setReactionSet((IReactionSet)newSet);
                }
            }
            JChemPaintModel jcpm = new JChemPaintModel(CreateCoordinatesForFileDialog.this.chemModel);
            CreateCoordinatesForFileDialog.this.closeFrame();
        }

        private IMolecule relayoutMolecule(IMolecule molecule) {
            IMolecule cleanedMol = molecule;
            if (molecule != null) {
                if (molecule.getAtomCount() > 2) {
                    try {
                        Point2d centre = GeometryTools.get2DCentreOfMass((IAtomContainer)molecule, (HashMap)CreateCoordinatesForFileDialog.this.renderingCoordinates);
                        this.diagramGenerator.setMolecule(molecule);
                        this.diagramGenerator.generateCoordinates(new Vector2d(0.0, 1.0));
                        cleanedMol = this.diagramGenerator.getMolecule();
                        GeometryTools.translateAllPositive((IAtomContainer)cleanedMol, (HashMap)CreateCoordinatesForFileDialog.this.renderingCoordinates);
                        GeometryTools.translate2DCentreOfMassTo((IAtomContainer)cleanedMol, (Point2d)centre, (HashMap)CreateCoordinatesForFileDialog.this.renderingCoordinates);
                    }
                    catch (Exception exc) {
                        CreateCoordinatesForFileDialog.this.logger.error((Object)"Could not generate coordinates for molecule");
                        CreateCoordinatesForFileDialog.this.logger.error((Object)exc.toString());
                    }
                } else {
                    CreateCoordinatesForFileDialog.this.logger.info((Object)"Molecule with less than 2 atoms are not cleaned up");
                }
            } else {
                CreateCoordinatesForFileDialog.this.logger.error((Object)"Molecule is null! Cannot do layout!");
            }
            return cleanedMol;
        }
    }

    class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = -2305492502437164455L;

        CancelAction() {
            super("Cancel");
        }

        public void actionPerformed(ActionEvent event) {
            CreateCoordinatesForFileDialog.this.closeFrame();
        }
    }
}

