/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint.action;

import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import javax.swing.undo.UndoableEdit;
import org.openscience.cdk.Atom;
import org.openscience.cdk.SingleElectron;
import org.openscience.cdk.applications.jchempaint.JChemPaintModel;
import org.openscience.cdk.applications.jchempaint.action.JCPAction;
import org.openscience.cdk.applications.undoredo.ConvertToRadicalEdit;
import org.openscience.cdk.config.AtomTypeFactory;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IElectronContainer;
import org.openscience.cdk.tools.manipulator.ChemModelManipulator;

public class ConvertToRadicalAction
extends JCPAction {
    private static final long serialVersionUID = 1898335761308427006L;

    public void actionPerformed(ActionEvent event) {
        logger.debug((Object)"Converting to radical: ", (Object)this.type);
        IChemObject object = this.getSource(event);
        JChemPaintModel jcpmodel = this.jcpPanel.getJChemPaintModel();
        IChemModel model = jcpmodel.getChemModel();
        if (object != null) {
            if (object instanceof Atom) {
                Atom atom = (Atom)object;
                IAtomContainer relevantContainer = ChemModelManipulator.getRelevantAtomContainer((IChemModel)model, (IAtom)atom);
                double number = this.controlLonePair(relevantContainer, atom);
                if (number > 0.0) {
                    SingleElectron electronContainer = new SingleElectron((IAtom)atom);
                    relevantContainer.addElectronContainer((IElectronContainer)electronContainer);
                    ConvertToRadicalEdit edit = new ConvertToRadicalEdit(relevantContainer, (IElectronContainer)electronContainer);
                    this.jcpPanel.getUndoSupport().postEdit((UndoableEdit)edit);
                    logger.info((Object)"Added single electron to atom");
                    logger.debug((Object)"new AC: ", (Object)relevantContainer);
                } else {
                    JOptionPane.showMessageDialog(this.jcpPanel, "A radical cannot be added to this atom. Re-try with less hydrogens.");
                }
            } else {
                logger.error((Object)"Object not an Atom! Cannot convert into a radical!");
            }
        } else {
            logger.warn((Object)"Cannot convert a null object!");
        }
        jcpmodel.fireChange();
    }

    private double controlLonePair(IAtomContainer container, Atom atom) {
        double nLonePair = 0.0;
        AtomTypeFactory atomATF = null;
        try {
            atomATF = AtomTypeFactory.getInstance((String)"org/openscience/cdk/config/data/valency2_atomtypes.xml", (IChemObjectBuilder)atom.getBuilder());
            if (atomATF != null) {
                IAtomType atomType = atomATF.getAtomType(atom.getSymbol());
                double bondOrderSum = container.getBondOrderSum((IAtom)atom);
                int charge = atom.getFormalCharge();
                int hcount = atom.getHydrogenCount();
                int valency = atomType.getValency();
                nLonePair = ((double)valency - ((double)hcount + bondOrderSum) - (double)charge) / 2.0;
            }
        }
        catch (Exception ex1) {
            logger.error((Object)ex1.getMessage());
            logger.debug((Object)ex1);
        }
        return nLonePair;
    }
}

