/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint;

import java.util.Vector;
import org.openscience.cdk.tools.LoggingTool;

public class UndoStack {
    public int capacity = 20;
    private LoggingTool logger;
    Vector stack = new Vector();
    int currentPosition = 0;

    public UndoStack() {
        this.logger = new LoggingTool((Object)this);
    }

    public UndoStack(int capacity) {
        this();
        this.capacity = capacity;
    }

    public Object pop() {
        Object o = null;
        if (this.stack.size() > 0) {
            o = this.stack.remove(this.stack.size() - 1);
            if (this.stack.size() <= this.currentPosition) {
                this.currentPosition = this.stack.size() - 1;
            }
            this.logger.debug((Object)("Object " + o.hashCode()), (Object)(" was taken away from the stack. Current stack size: " + this.stack.size()));
        }
        return o;
    }

    public void push(Object o) {
        this.logger.debug((Object)("Object " + o.hashCode()), (Object)" was pushed on the stack");
        if (this.currentPosition != this.stack.size() - 1) {
            this.logger.debug((Object)("CurrentPosition " + (this.currentPosition + 1)), (Object)(" < stack size " + this.stack.size()));
            this.logger.debug((Object)"Thus clearing stack to prevent confusion");
            this.stack.removeAllElements();
        }
        if (this.stack.size() < this.capacity) {
            this.logger.debug((Object)("Current size " + this.stack.size()), (Object)(" is smaller than capacity " + this.capacity));
            this.logger.debug((Object)"Thus the new model is just added");
            this.stack.addElement(o);
        } else {
            this.logger.debug((Object)("Current size " + this.stack.size()), (Object)(" has reached capacity " + this.capacity));
            this.logger.debug((Object)"Thus removing element at position 0");
            this.stack.remove(0);
            this.logger.debug((Object)"and now adding new element");
            this.stack.addElement(o);
        }
        this.currentPosition = this.stack.size() - 1;
        this.logger.debug((Object)this.listObjects());
    }

    public Object getCurrent() {
        return this.stack.elementAt(this.currentPosition);
    }

    public void undoShift() {
        this.logger.debug((Object)"Received undo shift command");
        if (this.currentPosition > 0) {
            --this.currentPosition;
        }
        this.logger.debug((Object)("currentPosition: " + (this.currentPosition + 1)), (Object)("/" + this.stack.size()));
        this.logger.debug((Object)this.listObjects());
    }

    public void redoShift() {
        this.logger.debug((Object)"Received redo shift command");
        if (this.currentPosition < this.stack.size() - 1) {
            ++this.currentPosition;
        }
        this.logger.debug((Object)("currentPosition: " + (this.currentPosition + 1)), (Object)("/" + this.stack.size()));
        this.logger.debug((Object)this.listObjects());
    }

    public int size() {
        return this.stack.size();
    }

    String listObjects() {
        String s = "List of Object hashcodes in the stack: \n";
        for (int i = 0; i < this.stack.size(); ++i) {
            s = s + this.stack.elementAt(i).hashCode() + "\n";
        }
        return s;
    }
}

