/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint;

import java.util.MissingResourceException;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openscience.cdk.applications.jchempaint.JCPLocalizationHandler;
import org.openscience.cdk.applications.jchempaint.JCPPropertyHandler;
import org.openscience.cdk.applications.jchempaint.JChemPaintPanel;
import org.openscience.cdk.applications.jchempaint.StringHelper;
import org.openscience.cdk.applications.jchempaint.action.JCPAction;
import org.openscience.cdk.controller.CDKPopupMenu;
import org.openscience.cdk.tools.LoggingTool;

public class JChemPaintPopupMenu
extends CDKPopupMenu {
    private static final long serialVersionUID = -1172105004348414589L;
    private LoggingTool logger = new LoggingTool((Object)this);

    JChemPaintPopupMenu(JChemPaintPanel jcpPanel, String type) {
        this.createPopupMenu(jcpPanel, type);
    }

    protected void createPopupMenu(JChemPaintPanel jcpPanel, String type) {
        String[] menuKeys = StringHelper.tokenize(this.getMenuResourceString(type + "popup"));
        String menuTitle = JCPLocalizationHandler.getInstance().getString(type + "MenuTitle");
        JMenuItem titleMenuItem = new JMenuItem(menuTitle);
        titleMenuItem.setEnabled(false);
        titleMenuItem.setArmed(false);
        this.add(titleMenuItem);
        this.addSeparator();
        for (int i = 0; i < menuKeys.length; ++i) {
            String menuKey = menuKeys[i];
            if (menuKey.equals("-")) {
                this.addSeparator();
                continue;
            }
            if (menuKey.startsWith("@")) {
                JMenu me = this.createMenu(jcpPanel, menuKey.substring(1));
                this.add(me);
                continue;
            }
            JMenuItem item = this.createMenuItem(jcpPanel, menuKey);
            if (item == null) continue;
            this.add(item);
        }
    }

    protected JMenuItem createMenuItem(JChemPaintPanel jcpPanel, String cmd) {
        this.logger.debug((Object)"Creating menu item: ", (Object)cmd);
        String translation = "***" + cmd + "***";
        try {
            translation = JCPLocalizationHandler.getInstance().getString(cmd);
        }
        catch (MissingResourceException mre) {
            this.logger.error((Object)("Could not find translation for: " + cmd));
        }
        JMenuItem mi = new JMenuItem(translation);
        String astr = JCPPropertyHandler.getInstance().getResourceString(cmd + "Action");
        if (astr == null) {
            astr = cmd;
        }
        mi.setActionCommand(astr);
        JCPAction a = jcpPanel.getJCPAction().getAction(jcpPanel, astr, true);
        if (a != null) {
            mi.addActionListener(a);
            mi.setEnabled(a.isEnabled());
        } else {
            this.logger.warn((Object)("Could not find JCPAction class for:" + astr));
            mi.setEnabled(false);
        }
        return mi;
    }

    protected JMenu createMenu(JChemPaintPanel jcpPanel, String key) {
        this.logger.debug((Object)"Creating menu: ", (Object)key);
        String[] itemKeys = StringHelper.tokenize(this.getMenuResourceString(key));
        String translation = "***" + key + "***";
        try {
            translation = JCPLocalizationHandler.getInstance().getString(key);
        }
        catch (MissingResourceException mre) {
            this.logger.error((Object)("Could not find translation for: " + key));
        }
        JMenu menu = new JMenu(translation);
        for (int i = 0; i < itemKeys.length; ++i) {
            if (itemKeys[i].equals("-")) {
                menu.addSeparator();
                continue;
            }
            if (itemKeys[i].startsWith("@")) {
                String menuTitle = itemKeys[i].substring(1);
                JMenu me = this.createMenu(jcpPanel, menuTitle);
                menu.add(me);
                continue;
            }
            JMenuItem mi = this.createMenuItem(jcpPanel, itemKeys[i]);
            menu.add(mi);
        }
        return menu;
    }

    public String getMenuResourceString(String key) {
        String str;
        try {
            str = JCPPropertyHandler.getInstance().getGUIDefinition().getString(key);
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }
}

