/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Hashtable;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Logger;
import org.jmol.viewer.Chain;
import org.jmol.viewer.JmolConstants;

class Group {
    Chain chain;
    int seqcode;
    short groupID;
    int firstAtomIndex = -1;
    int lastAtomIndex;
    int shapeVisibilityFlags = 0;
    int minZ;
    private static Hashtable htGroup = new Hashtable();
    static String[] group3Names = new String[128];
    static short group3NameCount = 0;

    Group(Chain chain, String group3, int seqcode, int firstAtomIndex, int lastAtomIndex) {
        this.chain = chain;
        this.seqcode = seqcode;
        if (group3 == null) {
            group3 = "";
        }
        this.groupID = Group.getGroupID(group3);
        this.firstAtomIndex = firstAtomIndex;
        this.lastAtomIndex = lastAtomIndex;
    }

    final void setShapeVisibility(int visFlag, boolean isVisible) {
        this.shapeVisibilityFlags = isVisible ? (this.shapeVisibilityFlags |= visFlag) : (this.shapeVisibilityFlags &= ~visFlag);
    }

    final boolean isGroup3(String group3) {
        return group3Names[this.groupID].equalsIgnoreCase(group3);
    }

    final String getGroup3() {
        return group3Names[this.groupID];
    }

    static String getGroup3(short groupID) {
        return group3Names[groupID];
    }

    final String getGroup1() {
        if (this.groupID >= JmolConstants.predefinedGroup1Names.length) {
            return "?";
        }
        return JmolConstants.predefinedGroup1Names[this.groupID];
    }

    final short getGroupID() {
        return this.groupID;
    }

    final boolean isGroup3Match(String strWildcard) {
        int cchWildcard;
        int ichWildcard = 0;
        String group3 = group3Names[this.groupID];
        int cchGroup3 = group3.length();
        if (cchWildcard < cchGroup3) {
            return false;
        }
        for (cchWildcard = strWildcard.length(); cchWildcard > cchGroup3; --cchWildcard) {
            if (strWildcard.charAt(ichWildcard) == '?') {
                ++ichWildcard;
                continue;
            }
            if (strWildcard.charAt(ichWildcard + cchWildcard - 1) == '?') continue;
            return false;
        }
        int i = cchGroup3;
        while (--i >= 0) {
            char charWild = strWildcard.charAt(ichWildcard + i);
            if (charWild == '?' || charWild == group3.charAt(i)) continue;
            return false;
        }
        return true;
    }

    final char getChainID() {
        return this.chain.chainID;
    }

    int getPolymerLength() {
        return 0;
    }

    int getPolymerIndex() {
        return -1;
    }

    byte getProteinStructureType() {
        return 0;
    }

    Hashtable getMyInfo() {
        return null;
    }

    boolean isProtein() {
        return false;
    }

    boolean isNucleic() {
        return false;
    }

    boolean isDna() {
        return false;
    }

    boolean isRna() {
        return false;
    }

    boolean isPurine() {
        return false;
    }

    boolean isPyrimidine() {
        return false;
    }

    boolean isCarbohydrate() {
        return false;
    }

    static synchronized short addGroup3Name(String group3) {
        if (group3NameCount == group3Names.length) {
            group3Names = ArrayUtil.doubleLength(group3Names);
        }
        short s = group3NameCount;
        group3NameCount = (short)(s + 1);
        short groupID = s;
        Group.group3Names[groupID] = group3;
        htGroup.put(group3, new Short(groupID));
        return groupID;
    }

    static short getGroupID(String group3) {
        if (group3 == null) {
            return -1;
        }
        short groupID = Group.lookupGroupID(group3);
        return groupID != -1 ? groupID : Group.addGroup3Name(group3);
    }

    static short lookupGroupID(String group3) {
        Short boxedGroupID;
        if (group3 != null && (boxedGroupID = (Short)htGroup.get(group3)) != null) {
            return boxedGroupID;
        }
        return -1;
    }

    final int getResno() {
        return this.seqcode >> 8;
    }

    final int getSeqcode() {
        return this.seqcode;
    }

    final String getSeqcodeString() {
        return Group.getSeqcodeString(this.seqcode);
    }

    static int getSeqcode(int sequenceNumber, char insertionCode) {
        if (sequenceNumber == Integer.MIN_VALUE) {
            return sequenceNumber;
        }
        if (!(insertionCode >= 'A' && insertionCode <= 'Z' || insertionCode >= 'a' && insertionCode <= 'z' || insertionCode >= '0' && insertionCode <= '9' || insertionCode == '?' || insertionCode == '*')) {
            if (insertionCode != ' ' && insertionCode != '\u0000') {
                Logger.warn("unrecognized insertionCode:" + insertionCode);
            }
            insertionCode = '\u0000';
        }
        return (sequenceNumber << 8) + insertionCode;
    }

    static String getSeqcodeString(int seqcode) {
        if (seqcode == Integer.MIN_VALUE) {
            return null;
        }
        return (seqcode & 0xFF) == 0 ? "" + (seqcode >> 8) : "" + (seqcode >> 8) + '^' + (char)(seqcode & 0xFF);
    }

    char getInsertionCode() {
        if (this.seqcode == Integer.MIN_VALUE) {
            return '\u0000';
        }
        return (char)(this.seqcode & 0xFF);
    }

    static char getInsertionCode(int seqcode) {
        if (seqcode == Integer.MIN_VALUE) {
            return '\u0000';
        }
        return (char)(seqcode & 0xFF);
    }

    final void selectAtoms(BitSet bs) {
        for (int i = this.firstAtomIndex; i <= this.lastAtomIndex; ++i) {
            bs.set(i);
        }
    }

    boolean isSelected(BitSet bs) {
        for (int i = this.firstAtomIndex; i <= this.lastAtomIndex; ++i) {
            if (!bs.get(i)) continue;
            return true;
        }
        return false;
    }

    boolean isHetero() {
        return this.chain.frame.atoms[this.firstAtomIndex].isHetero();
    }

    public String toString() {
        return "[" + this.getGroup3() + "-" + this.getSeqcodeString() + "]";
    }

    static {
        for (int i = 0; i < JmolConstants.predefinedGroup3Names.length; ++i) {
            Group.addGroup3Name(JmolConstants.predefinedGroup3Names[i]);
        }
    }
}

