/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.CarbohydratePolymer;
import org.jmol.viewer.Cartoon;
import org.jmol.viewer.Helix;
import org.jmol.viewer.Monomer;
import org.jmol.viewer.Mps;
import org.jmol.viewer.MpsRenderer;
import org.jmol.viewer.NucleicMonomer;
import org.jmol.viewer.NucleicPolymer;
import org.jmol.viewer.Polymer;
import org.jmol.viewer.ProteinStructure;

class CartoonRenderer
extends MpsRenderer {
    final Point3f pointT = new Point3f();
    static final float MIN_CONE_HEIGHT = 0.05f;
    boolean newRockets;
    boolean isNucleicPolymer;
    boolean isCarbohydratePolymer;
    boolean ribbonBorder = false;
    int monomerCount;
    Monomer[] monomers;
    Point3f[] leadMidpoints;
    Vector3f[] wingVectors;
    short[] mads;
    short[] colixes;
    boolean[] isSpecials;
    boolean[] isHelixes;
    Point3i[] leadMidpointScreens;
    Point3i[] ribbonTopScreens;
    Point3i[] ribbonBottomScreens;
    int myVisibilityFlag;
    boolean renderAsRockets;
    Point3i[] screens;
    Point3f[] screensf;
    Point3f[] cordMidPoints;
    boolean tPending;
    ProteinStructure proteinstructurePending;
    int startIndexPending;
    int endIndexPending;
    short madPending;
    short colixPending;
    int[] shadesPending;
    int lastDiameter;
    final Point3f screenA = new Point3f();
    Point3f screenB = new Point3f();
    Point3f screenC = new Point3f();
    final Point3i screenArrowTop = new Point3i();
    final Point3i screenArrowTopPrev = new Point3i();
    final Point3i screenArrowBot = new Point3i();
    final Point3i screenArrowBotPrev = new Point3i();
    final Point3f[] ring6Points = new Point3f[6];
    final Point3i[] ring6Screens = new Point3i[6];
    final Point3f[] ring5Points = new Point3f[5];
    final Point3i[] ring5Screens = new Point3i[5];

    CartoonRenderer() {
        this.ring6Screens[5] = new Point3i();
        int i = 5;
        while (--i >= 0) {
            this.ring5Screens[i] = new Point3i();
            this.ring6Screens[i] = new Point3i();
        }
    }

    void calc1Screen(Point3f center, Vector3f vector, short mad, float offsetFraction, Point3i screen) {
        this.pointT.set(vector);
        float scale = (float)mad * offsetFraction;
        this.pointT.scaleAdd(scale, center);
        this.viewer.transformPoint(this.pointT, screen);
    }

    Point3i[] calcScreens(Point3f[] centers, Vector3f[] vectors, short[] mads, float offsetFraction) {
        int count = centers.length;
        Point3i[] screens = this.viewer.allocTempScreens(count);
        if (offsetFraction == 0.0f) {
            int i = count;
            while (--i >= 0) {
                this.viewer.transformPoint(centers[i], screens[i]);
            }
        } else {
            int i = count;
            while (--i >= 0) {
                this.pointT.set(vectors[i]);
                short mad = mads[i];
                float scale = (float)mad * offsetFraction;
                this.pointT.scaleAdd(scale, centers[i]);
                this.viewer.transformPoint(this.pointT, screens[i]);
            }
        }
        return screens;
    }

    void renderMpspolymer(Mps.Mpspolymer mpspolymer, int myVisibilityFlag) {
        Cartoon.Cchain strandsChain = (Cartoon.Cchain)mpspolymer;
        this.myVisibilityFlag = myVisibilityFlag;
        this.newRockets = true;
        this.renderAsRockets = this.viewer.getCartoonRocketFlag();
        if (strandsChain.wingVectors != null) {
            this.monomerCount = strandsChain.monomerCount;
            this.monomers = strandsChain.monomers;
            this.leadMidpoints = strandsChain.leadMidpoints;
            this.wingVectors = strandsChain.wingVectors;
            this.mads = strandsChain.mads;
            this.colixes = strandsChain.colixes;
            this.ribbonBorder = this.viewer.getRibbonBorder();
            if (!this.initializeChain(strandsChain.polymer)) {
                return;
            }
            this.render1Chain();
        }
    }

    boolean initializeChain(Polymer polymer) {
        this.isNucleicPolymer = polymer instanceof NucleicPolymer;
        this.isCarbohydratePolymer = polymer instanceof CarbohydratePolymer;
        if (this.isCarbohydratePolymer) {
            return false;
        }
        this.isSpecials = this.calcIsSpecials(this.monomerCount, this.monomers);
        this.isHelixes = this.calcIsHelix(this.monomerCount, this.monomers);
        this.leadMidpointScreens = this.calcScreenLeadMidpoints(this.monomerCount, this.leadMidpoints);
        this.ribbonTopScreens = this.calcScreens(this.leadMidpoints, this.wingVectors, this.mads, this.isNucleicPolymer ? 0.001f : 5.0E-4f);
        this.ribbonBottomScreens = this.calcScreens(this.leadMidpoints, this.wingVectors, this.mads, this.isNucleicPolymer ? 0.0f : -5.0E-4f);
        if (!this.isNucleicPolymer) {
            this.calcRopeMidPoints(polymer, this.newRockets);
        }
        this.clearPending();
        return true;
    }

    void calcRopeMidPoints(Polymer polymer, boolean isNewStyle) {
        Point3f point;
        int i;
        int midPointCount = this.monomerCount + 1;
        this.cordMidPoints = this.viewer.allocTempPoints(midPointCount);
        ProteinStructure proteinstructurePrev = null;
        for (i = 0; i < this.monomerCount; ++i) {
            point = this.cordMidPoints[i];
            Monomer residue = this.monomers[i];
            if (isNewStyle) {
                polymer.getLeadMidPoint(i, point);
                continue;
            }
            if (this.isSpecials[i]) {
                ProteinStructure proteinstructure = residue.getProteinStructure();
                point.set(i - 1 != proteinstructure.getMonomerIndex() ? proteinstructure.getAxisStartPoint() : proteinstructure.getAxisEndPoint());
                proteinstructurePrev = proteinstructure;
                continue;
            }
            if (proteinstructurePrev != null) {
                point.set(proteinstructurePrev.getAxisEndPoint());
            } else {
                polymer.getLeadMidPoint(i, point);
            }
            proteinstructurePrev = null;
        }
        point = this.cordMidPoints[this.monomerCount];
        if (proteinstructurePrev != null) {
            point.set(proteinstructurePrev.getAxisEndPoint());
        } else {
            polymer.getLeadMidPoint(this.monomerCount, point);
        }
        this.screens = this.viewer.allocTempScreens(midPointCount);
        this.screensf = this.viewer.allocTempPoints(midPointCount);
        i = midPointCount;
        while (--i >= 0) {
            this.viewer.transformPoint(this.cordMidPoints[i], this.screensf[i]);
            this.screens[i].x = (int)Math.floor(this.screensf[i].x);
            this.screens[i].y = (int)Math.floor(this.screensf[i].y);
            this.screens[i].z = (int)Math.floor(this.screensf[i].z);
        }
    }

    void clearPending() {
        this.tPending = false;
    }

    void render1Chain() {
        boolean isHelix;
        short colix;
        Monomer group;
        boolean lastWasSheet = false;
        boolean lastWasHelix = false;
        int i = this.monomerCount;
        while (--i >= 0) {
            group = this.monomers[i];
            if ((group.shapeVisibilityFlags & this.myVisibilityFlag) != 0 && !this.frame.bsHidden.get(group.getLeadAtomIndex())) {
                boolean isHelixRocket;
                colix = Graphics3D.inheritColix(this.colixes[i], group.getLeadAtom().colixAtom);
                isHelix = this.isHelixes[i];
                boolean isSheet = this.isSpecials[i] && !isHelix;
                boolean bl = isHelixRocket = this.renderAsRockets ? isHelix : false;
                if (!isHelixRocket) {
                    if (isSheet || isHelix) {
                        if (lastWasSheet && isSheet || lastWasHelix && isHelix) {
                            this.render2StrandSegment(this.monomerCount, group, colix, this.mads, i);
                        } else {
                            this.render2StrandArrowhead(this.monomerCount, group, colix, this.mads, i);
                        }
                    } else {
                        if (lastWasHelix && !isHelix && !isSheet) {
                            this.renderRopeSegment(colix, this.mads, i, this.monomerCount, this.monomers, this.screens, this.isSpecials);
                        } else if (!this.renderAsRockets || i == 0 || !this.isHelixes[i - 1]) {
                            this.renderRopeSegment(colix, this.mads, i, this.monomerCount, this.monomers, this.leadMidpointScreens, this.isSpecials);
                        }
                        if (this.isNucleicPolymer) {
                            this.renderNucleicBaseStep((NucleicMonomer)group, colix, this.mads[i], this.leadMidpointScreens[i + 1]);
                        }
                    }
                }
                lastWasSheet = isSheet;
                lastWasHelix = isHelix;
                continue;
            }
            lastWasSheet = false;
            lastWasHelix = false;
        }
        if (this.renderAsRockets && !this.isNucleicPolymer && !this.isCarbohydratePolymer) {
            lastWasHelix = false;
            for (i = 0; i < this.monomerCount; ++i) {
                if ((this.monomers[i].shapeVisibilityFlags & this.myVisibilityFlag) == 0) continue;
                group = this.monomers[i];
                if ((group.shapeVisibilityFlags & this.myVisibilityFlag) == 0) continue;
                colix = Graphics3D.inheritColix(this.colixes[i], group.getLeadAtom().colixAtom);
                isHelix = this.isHelixes[i];
                if (isHelix) {
                    this.renderHelixAsRocket(group, colix, this.mads[i], i > 0 && this.isHelixes[i - 1]);
                    if (this.newRockets && i > 0 && !this.isSpecials[i - 1]) {
                        this.renderRopeSegment2(colix, this.mads, i, i - 1, this.monomerCount, this.monomers, this.screens, null);
                    }
                } else if (!this.isSpecials[i] && lastWasHelix) {
                    if (this.newRockets) {
                        this.renderRopeSegment2(colix, this.mads, i - 1, i, this.monomerCount, this.monomers, this.screens, null);
                    }
                    this.renderRopeSegment(colix, this.mads, i, this.monomerCount, this.monomers, this.screens, this.isSpecials);
                }
                lastWasHelix = isHelix;
            }
            this.renderPendingRocketSegment(true);
            this.viewer.freeTempScreens(this.screens);
            this.viewer.freeTempPoints(this.cordMidPoints);
            this.viewer.freeTempPoints(this.screensf);
        }
        this.viewer.freeTempScreens(this.ribbonTopScreens);
        this.viewer.freeTempScreens(this.ribbonBottomScreens);
        this.viewer.freeTempScreens(this.leadMidpointScreens);
        this.viewer.freeTempBooleans(this.isSpecials);
        this.viewer.freeTempBooleans(this.isHelixes);
    }

    void renderHelixAsRocket(Monomer monomer, short colix, short mad, boolean isEnd) {
        this.lastDiameter = Integer.MAX_VALUE;
        ProteinStructure proteinstructure = monomer.getProteinStructure();
        if (this.tPending) {
            if (proteinstructure == this.proteinstructurePending && mad == this.madPending && colix == this.colixPending && proteinstructure.getIndex(monomer) == this.endIndexPending + 1) {
                ++this.endIndexPending;
                return;
            }
            this.renderPendingRocketSegment(isEnd);
        }
        this.proteinstructurePending = proteinstructure;
        this.startIndexPending = this.endIndexPending = proteinstructure.getIndex(monomer);
        this.colixPending = colix;
        this.madPending = mad;
        this.tPending = true;
    }

    void renderPendingRocketSegment(boolean isEnd) {
        if (!this.tPending) {
            return;
        }
        this.tPending = false;
        if (this.proteinstructurePending instanceof Helix) {
            Point3f[] segments = this.proteinstructurePending.getSegments();
            boolean tEnd = this.endIndexPending == this.proteinstructurePending.getMonomerCount() - 1;
            this.renderPendingRocketSegment(segments[this.startIndexPending], segments[this.endIndexPending], segments[this.endIndexPending + 1], tEnd, this.startIndexPending == 0);
        }
    }

    void renderPendingRocketSegment(Point3f pointStart, Point3f pointBeforeEnd, Point3f pointEnd, boolean tEnd, boolean isEnd) {
        this.viewer.transformPoint(pointStart, this.screenA);
        this.viewer.transformPoint(pointEnd, this.screenB);
        int zMid = (int)Math.floor((this.screenA.z + this.screenB.z) / 2.0f);
        short diameter = this.viewer.scaleToScreen(zMid, this.madPending);
        if (tEnd) {
            this.viewer.transformPoint(pointBeforeEnd, this.screenC);
            if (pointBeforeEnd.distance(pointEnd) > 0.05f) {
                short coneDiameter = this.viewer.scaleToScreen((int)Math.floor(this.screenC.z), this.madPending + (this.madPending >> 2));
                this.g3d.fillCone(this.colixPending, (byte)2, (int)coneDiameter, this.screenC, this.screenB);
                this.lastDiameter = coneDiameter;
            } else {
                this.g3d.fillCylinderBits(this.colixPending, (byte)2, (int)diameter, this.screenB, this.screenC);
                this.lastDiameter = Integer.MAX_VALUE;
            }
            if (this.startIndexPending == this.endIndexPending) {
                return;
            }
            Point3f t = this.screenB;
            this.screenB = this.screenC;
            this.screenC = t;
        }
        this.g3d.fillCylinderBits(this.colixPending, (byte)2, (int)diameter, this.screenA, this.screenB);
        this.lastDiameter = diameter;
    }

    void render2StrandSegment(int monomerCount, Monomer group, short colix, short[] mads, int i) {
        int iNext2;
        int iNext;
        int iLast = monomerCount;
        int iPrev = i - 1;
        if (iPrev < 0) {
            iPrev = 0;
        }
        if ((iNext = i + 1) > iLast) {
            iNext = iLast;
        }
        if ((iNext2 = i + 2) > iLast) {
            iNext2 = iLast;
        }
        this.g3d.drawHermite(true, this.ribbonBorder, colix, this.isNucleicPolymer ? 4 : 7, this.ribbonTopScreens[iPrev], this.ribbonTopScreens[i], this.ribbonTopScreens[iNext], this.ribbonTopScreens[iNext2], this.ribbonBottomScreens[iPrev], this.ribbonBottomScreens[i], this.ribbonBottomScreens[iNext], this.ribbonBottomScreens[iNext2], this.renderAsRockets ? 8 : 0);
    }

    void render2StrandArrowhead(int monomerCount, Monomer group, short colix, short[] mads, int i) {
        int iNext2;
        int iNext;
        int iLast = monomerCount;
        int iPrev = i - 1;
        if (iPrev < 0) {
            iPrev = 0;
        }
        if ((iNext = i + 1) > iLast) {
            iNext = iLast;
        }
        if ((iNext2 = i + 2) > iLast) {
            iNext2 = iLast;
        }
        this.calc1Screen(this.leadMidpoints[i], this.wingVectors[i], mads[i], 7.0E-4f, this.screenArrowTop);
        this.calc1Screen(this.leadMidpoints[iPrev], this.wingVectors[iPrev], mads[iPrev], 0.001f, this.screenArrowTopPrev);
        this.calc1Screen(this.leadMidpoints[i], this.wingVectors[i], mads[i], -7.0E-4f, this.screenArrowBot);
        this.calc1Screen(this.leadMidpoints[i], this.wingVectors[i], mads[i], -0.001f, this.screenArrowBotPrev);
        if (this.ribbonBorder) {
            this.g3d.fillCylinder(colix, colix, (byte)3, 3, this.screenArrowTop.x, this.screenArrowTop.y, this.screenArrowTop.z, this.screenArrowBot.x, this.screenArrowBot.y, this.screenArrowBot.z);
        }
        this.g3d.drawHermite(true, this.ribbonBorder, colix, this.isNucleicPolymer ? 4 : 7, this.screenArrowTopPrev, this.screenArrowTop, this.leadMidpointScreens[iNext], this.leadMidpointScreens[iNext2], this.screenArrowBotPrev, this.screenArrowBot, this.leadMidpointScreens[iNext], this.leadMidpointScreens[iNext2], this.renderAsRockets ? 8 : 0);
    }

    void renderNucleicBaseStep(NucleicMonomer nucleotide, short colix, short mad, Point3i backboneScreen) {
        Point3i stepScreen;
        nucleotide.getBaseRing6Points(this.ring6Points);
        this.viewer.transformPoints(this.ring6Points, this.ring6Screens);
        this.renderRing6(colix);
        boolean hasRing5 = nucleotide.maybeGetBaseRing5Points(this.ring5Points);
        if (hasRing5) {
            this.viewer.transformPoints(this.ring5Points, this.ring5Screens);
            this.renderRing5();
            stepScreen = this.ring5Screens[2];
        } else {
            stepScreen = this.ring6Screens[1];
        }
        this.g3d.fillCylinder(colix, (byte)3, this.viewer.scaleToScreen(backboneScreen.z, mad > 1 ? mad / 2 : mad), backboneScreen, stepScreen);
        --this.ring6Screens[5].z;
        int i = 5;
        while (--i > 0) {
            --this.ring6Screens[i].z;
            if (!hasRing5) continue;
            --this.ring5Screens[i].z;
        }
        i = 6;
        while (--i > 0) {
            this.g3d.fillCylinder(colix, (byte)3, 3, this.ring6Screens[i], this.ring6Screens[i - 1]);
        }
        if (hasRing5) {
            i = 5;
            while (--i > 0) {
                this.g3d.fillCylinder(colix, (byte)3, 3, this.ring5Screens[i], this.ring5Screens[i - 1]);
            }
        } else {
            this.g3d.fillCylinder(colix, (byte)3, 3, this.ring6Screens[5], this.ring6Screens[0]);
        }
    }

    void renderRing6(short colix) {
        this.g3d.calcSurfaceShade(colix, this.ring6Screens[0], this.ring6Screens[2], this.ring6Screens[4]);
        this.g3d.fillTriangle(this.ring6Screens[0], this.ring6Screens[2], this.ring6Screens[4]);
        this.g3d.fillTriangle(this.ring6Screens[0], this.ring6Screens[1], this.ring6Screens[2]);
        this.g3d.fillTriangle(this.ring6Screens[0], this.ring6Screens[4], this.ring6Screens[5]);
        this.g3d.fillTriangle(this.ring6Screens[2], this.ring6Screens[3], this.ring6Screens[4]);
    }

    void renderRing5() {
        this.g3d.fillTriangle(this.ring5Screens[0], this.ring5Screens[2], this.ring5Screens[3]);
        this.g3d.fillTriangle(this.ring5Screens[0], this.ring5Screens[1], this.ring5Screens[2]);
        this.g3d.fillTriangle(this.ring5Screens[0], this.ring5Screens[3], this.ring5Screens[4]);
    }
}

