/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import org.jmol.viewer.Atom;
import org.jmol.viewer.ShapeRenderer;
import org.jmol.viewer.Viewer;

class BallsRenderer
extends ShapeRenderer {
    int minX;
    int maxX;
    int minY;
    int maxY;
    int minZ;
    int maxZ;
    int ballVisibilityFlag;
    boolean labelsGroup;

    BallsRenderer() {
    }

    void initRenderer() {
        this.ballVisibilityFlag = Viewer.getShapeVisibilityFlag(0);
    }

    void render() {
        int i;
        this.minX = this.rectClip.x;
        this.maxX = this.minX + this.rectClip.width;
        this.minY = this.rectClip.y;
        this.maxY = this.minY + this.rectClip.height;
        boolean slabbing = this.viewer.getSlabEnabled();
        if (slabbing) {
            this.minZ = this.g3d.getSlab();
            this.maxZ = this.g3d.getDepth();
        }
        this.labelsGroup = this.viewer.getLabelsGroupFlag() && !this.viewer.getLabelsFrontFlag();
        Atom[] atoms = this.frame.atoms;
        if (this.labelsGroup) {
            i = this.frame.groupCount;
            while (--i >= 0) {
                this.frame.groups[i].minZ = Integer.MAX_VALUE;
            }
        }
        i = this.frame.atomCount;
        while (--i >= 0) {
            int z;
            Atom atom = atoms[i];
            if ((atom.shapeVisibilityFlags & 1) == 0) continue;
            atom.transform(this.viewer);
            if (slabbing && this.g3d.isClippedZ(atom.screenZ)) {
                atom.clickabilityFlags = 0;
                int r = atom.screenDiameter / 2;
                if (atom.screenZ < this.minZ - r || atom.screenZ > this.maxZ + r) continue;
            }
            if (this.labelsGroup && atom.group != null && (z = atom.getScreenZ() - atom.getScreenD() / 2 - 2) < atom.group.minZ) {
                atom.group.minZ = Math.max(1, z);
            }
            if ((atom.shapeVisibilityFlags & this.ballVisibilityFlag) == 0) continue;
            this.renderBall(atom);
        }
    }

    void renderBall(Atom atom) {
        this.g3d.fillSphereCentered(atom.colixAtom, atom.screenDiameter, atom.screenX, atom.screenY, atom.screenZ);
    }
}

