% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EllipticCurves.R
\docType{methods}
\name{ecoperators}
\alias{ecoperators}
\alias{doubleUp}
\alias{doubleUp,ECPOINT-method}
\alias{+,ECPOINT,ECPOINT-method}
\alias{leftmostBit}
\alias{leftmostBit,bigz-method}
\alias{AND}
\alias{AND,bigz,bigz-method}
\alias{*,ECPOINT,bigz-method}
\alias{*,bigz,ECPOINT-method}
\title{Elliptic curve operators}
\usage{
doubleUp(ecp)

\S4method{doubleUp}{ECPOINT}(ecp)

\S4method{+}{ECPOINT,ECPOINT}(e1, e2)

leftmostBit(x)

\S4method{leftmostBit}{bigz}(x)

AND(x, y)

\S4method{AND}{bigz,bigz}(x, y)

\S4method{*}{ECPOINT,bigz}(e1, e2)

\S4method{*}{bigz,ECPOINT}(e1, e2)
}
\arguments{
\item{ecp}{point on elliptic curve}

\item{e1}{point on elliptic curve, or integer}

\item{e2}{point on elliptic curve, or integer}

\item{x}{integer}

\item{y}{integer}
}
\description{
The following operarations for EC points
are available:
\itemize{
\item{doubleUp}{multiplying a point by itself}
\item{+}{point addition}
\item{leftmostBit}{highest bit value of an integer}
\item{AND}{logical and-operator for two integers}
\item{*}{multiplication of an integer scalar with an EC point}
}
}
\references{
\url{https://en.bitcoin.it/wiki/Secp256k1}
}
\seealso{
Other EllipticCurve: \code{\link{ECPARAM-class}},
  \code{\link{ECPOINT-class}},
  \code{\link{EcparamOrNull-class}},
  \code{\link{containsPoint}}, \code{\link{ecparam}},
  \code{\link{ecpoint}}, \code{\link{isNull}}
}
\author{
Bernhard Pfaff
}
\concept{EllipticCurve}
