% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_utils.R
\name{gcomp_responder_multi}
\alias{gcomp_responder_multi}
\title{G-computation for a Binary Outcome at Multiple Visits}
\usage{
gcomp_responder_multi(data, vars, reference_levels = NULL, ...)
}
\arguments{
\item{data}{A data.frame containing multiple visits.}

\item{vars}{A list specifying analysis variables.}

\item{reference_levels}{Optional reference level for the treatment variable.}

\item{...}{Additional arguments passed to \code{gcomp_responder()}.}
}
\value{
A named list of estimates for each visit and treatment group.
}
\description{
Applies \code{gcomp_responder()} separately for each unique visit in the data.
}
\examples{
\donttest{
library(dplyr)
library(rbmi)
library(rbmiUtils)

data("ADMI")

ADMI <- ADMI |>
  mutate(
    TRT = factor(TRT, levels = c("Placebo", "Drug A")),
    STRATA = factor(STRATA),
    REGION = factor(REGION)
  )

# Note: method must match the original used for imputation
method <- method_bayes(
  n_samples = 100,
  control = control_bayes(warmup = 20, thin = 2)
)

vars_binary <- set_vars(
  subjid = "USUBJID",
  visit = "AVISIT",
  group = "TRT",
  outcome = "CRIT1FLN",
  covariates = c("BASE", "STRATA", "REGION")
)

ana_obj_prop <- analyse_mi_data(
  data = ADMI,
  vars = vars_binary,
  method = method,
  fun = gcomp_responder_multi,
  reference_levels = "Placebo",
  contrast = "diff",
  var_method = "Ge",
  type = "HC0"
)

pool(ana_obj_prop)
}
}
