% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module-create.R
\name{module_add}
\alias{module_add}
\title{Add new 'RAVE' (2.0) module to current project}
\usage{
module_add(
  module_id,
  module_label,
  path = ".",
  type = c("default", "bare", "scheduler", "python"),
  ...,
  pipeline_name = module_id,
  overwrite = FALSE
)
}
\arguments{
\item{module_id}{module ID to create, must be unique; users cannot install
two modules with identical module ID. We recommend that
a module ID follows snake format, starting with lab name, for example,
\code{'beauchamplab_imaging_preprocess'}, \code{'karaslab_freez'}, or
\code{'upenn_ese25_fooof'}.}

\item{module_label}{a friendly label to display in the dashboard}

\item{path}{project root path; default is current directory}

\item{type}{template to choose, options are \code{'default'} and
\code{'bare'}}

\item{...}{additional configurations to the module such as \code{'order'},
\code{'group'}, \code{'badge'}}

\item{pipeline_name}{the pipeline name to create along with the module;
default is identical to \code{module_id} (strongly recommended); leave
it default unless you know what you are doing.}

\item{overwrite}{whether to overwrite existing module if module with
same ID exists; default is false}
}
\value{
Nothing.
}
\description{
Creates a 'RAVE' pipeline with additional dashboard module from template.
}
\examples{


# For demonstrating this example only
project_root <- tempfile()
dir.create(project_root, showWarnings = FALSE, recursive = TRUE)


# Add a module
module_id <- "mylab_my_first_module"
module_add(
  module_id = module_id,
  module_label = "My Pipeline",
  path = project_root
)


# show the structure
cat(
  list.files(
    project_root,
    recursive = TRUE,
    full.names = FALSE,
    include.dirs = TRUE
  ),
  sep = "\n"
)

unlink(project_root, recursive = TRUE)


}
