% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rare.cv.R
\name{rarefit.predict}
\alias{rarefit.predict}
\title{Make predictions from a rarefit object and a rarefit.cv object}
\usage{
rarefit.predict(fitObj, cvObj, newx)
}
\arguments{
\item{fitObj}{Output of \code{rarefit}.}

\item{cvObj}{Output of \code{rarefit.cv}.}

\item{newx}{Matrix of new values for x at which predictions are made.}
}
\value{
Returns a sequence of predictions.
}
\description{
The function makes predictions using a \code{rarefit} object at optimal
(\code{lambda}, \code{alpha}) chosen by \code{rarefit.cv}.
}
\examples{
\dontrun{
# See vignette for more details.
set.seed(100)
ts <- sample(1:length(data.rating), 400) # Train set indices
# Fit the model on train set
ourfit <- rarefit(y = data.rating[ts], X = data.dtm[ts, ], hc = data.hc, lam.min.ratio = 1e-6,
                  nlam = 20, nalpha = 10, rho = 0.01, eps1 = 1e-5, eps2 = 1e-5, maxite = 1e4)
# Cross validation
ourfit.cv <- rarefit.cv(ourfit, y = data.rating[ts], X = data.dtm[ts, ],
                        rho = 0.01, eps1 = 1e-5, eps2 = 1e-5, maxite = 1e4)
# Prediction on test set
pred <- rarefit.predict(ourfit, ourfit.cv, data.dtm[-ts, ])
pred.error <- mean((pred - data.rating[-ts])^2)
}

}
\seealso{
\code{\link{rarefit}}, \code{\link{rarefit.cv}}
}
