% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RN_plot_search_results.R
\name{RN_plot_search_results}
\alias{RN_plot_search_results}
\title{Plot results of RN_search functions}
\usage{
RN_plot_search_results(discrete_df,
  title = deparse(substitute(discrete_df)), log_plot = 0)
}
\arguments{
\item{discrete_df}{A data frame results from a `radsafer` search function. Columns must
include RN, E_MeV, and prob, and code_AN.}

\item{title}{Title for chart (default = name of search_results)}

\item{log_plot}{0 = no log axes (default), 1  = log y-axis, 2 = log both axes.}
}
\description{
Plots results by radionuclide with E_MeV on x-axis and prob on y-axis.
}
\examples{
search_results <- RN_search_phot_by_E(0.99, 1.01, 13 * 60, 15 * 60, 1e-4)
RN_plot_search_results(search_results, title = "example1", log_plot = 0)
}
\seealso{
Use \code{\link{RN_search_alpha_by_E}}, \code{\link{RN_search_beta_by_E}}, 
or \code{\link{RN_search_phot_by_E}} and save the results, 
e.g. save_results <- RN_search_phot_by_E(0.99, 1.01, 13 * 60, 15 * 60, 1e-4)

Other radionuclides: \code{\link{RN_Spec_Act}},
  \code{\link{RN_index_screen}}, \code{\link{RN_info}},
  \code{\link{RN_plot_spectrum}},
  \code{\link{RN_save_spectrum}},
  \code{\link{RN_search_alpha_by_E}},
  \code{\link{RN_search_beta_by_E}},
  \code{\link{RN_search_phot_by_E}},
  \code{\link{bin_screen_phot}},
  \code{\link{search_alpha_by_E}},
  \code{\link{search_beta_by_E}},
  \code{\link{search_phot_by_E}}
}
\concept{radionuclides}
