% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcnp_plot_out_spec.R
\name{mcnp_plot_out_spec}
\alias{mcnp_plot_out_spec}
\title{Convert histogram data to average points and plot as spectrum.}
\usage{
mcnp_plot_out_spec(spec.df, title, log_axes = FALSE)
}
\arguments{
\item{spec.df}{A data frame with no header. Maximum energy in MeV should be
in the first column, binned results in the second column, uncertainty in
the third column.}

\item{title}{Title for chart}

\item{log_axes}{TRUE for both axes logarithmic}
}
\description{
Model results from MCNP and perhaps other sources typically
  provide binned tally results with columns representing maximum energy in
  MeV, a column with the mean tally result titled 'mean' and an uncertainty
  column titled 'R'.
}
\examples{
mcnp_plot_out_spec(photons_cs137_hist, "example Cs-137 well irradiator")
}
\seealso{
\code{\link{scan2spec.df}} to copy and paste output spectrum.

Other mcnp tools: \code{\link{mcnp_cone_angle}},
  \code{\link{mcnp_est_nps}},
  \code{\link{mcnp_matrix_rotations}},
  \code{\link{mcnp_scan2spec}},
  \code{\link{mcnp_si_sp_RD}},
  \code{\link{mcnp_si_sp_hist_scan}},
  \code{\link{mcnp_si_sp_hist}}
}
\concept{mcnp tools}
