% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SRD_utility.R
\name{utilsDetailedSRD}
\alias{utilsDetailedSRD}
\title{utilsDetailedSRD}
\usage{
utilsDetailedSRD(
  df,
  referenceCol,
  createRefCol = function() {
 }
)
}
\arguments{
\item{df}{A DataFrame.}

\item{referenceCol}{Optional. A string that contains a column of \code{df} which will be used as the reference column.}

\item{createRefCol}{Optional. Can be max, min, median, mean. Creates a new Column based on the existing \code{df} and attaches it to  \code{df} as the reference Column.}
}
\value{
Returns a new DataFrame that shows the detailed SRD computation (ranking transformation and distance calculation). A newly added row contains the SRD values (displayed without normalization).
}
\description{
Detailed calculation of the SRD values including the computation of the ranking transformation. 
Unless there is a column specified with referenceCol the last column will always taken as the reference.
}
\examples{
SRDInput <- data.frame(
A=c(32, 52, 44, 44, 47),
B=c(73, 75, 65, 76, 70),
C=c(60, 59, 57, 55, 60),
D=c(35, 24, 44, 83, 47),
E=c(41, 52, 46, 50, 65))
rSRD::utilsDetailedSRD(SRDInput)
}
\author{
Ali Tugay Sen
}
