% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sourceSHAPE.R
\name{mutationFunction}
\alias{mutationFunction}
\title{This allows SHAPE to simulate the mutation process as a deterministic value.  At present, values must be tracked as integer results
for reasons of how I am passing to functions which identify what mutant genotype(s) are created.}
\usage{
mutationFunction(func_inSize, func_inProb = 0)
}
\arguments{
\item{func_inSize}{This is the vector of the population sizes, or perhaps number of births, or sum of both, within the community.  Which vector
gets passed will depend on which growth form and other parameters are being implemented by SHAPE.}

\item{func_inProb}{This is the general mutation rate (probability) defined for this run of SHAPE. It is a per individual considered value, by
which I mean that each mutant will have a single new mutation (or reversion if allowed - handled elsewhere) and so this probability is based
on the vector of individuals passed and any context of if it is a "per generation" value relates to how time steps and birth probabilities are handled in the run.}
}
\value{
A vector of the number of mutants produced by each of the populations represented by the func_inSize vector
}
\description{
This allows SHAPE to simulate the mutation process as a deterministic value.  At present, values must be tracked as integer results
for reasons of how I am passing to functions which identify what mutant genotype(s) are created.
}
\examples{
# The number of mutants generated is forcibly integer but is based
# on the stochastic rounding of the product of the number of potentially
# mutable individuals and their probability of mutation.
mutationFunction(c(10,50,100),func_inProb = 0.3)
replicate(5,mutationFunction(c(10,50,100),func_inProb = 0.35))

}
