% Generated by roxygen2 (4.0.2): do not edit by hand
\name{show.query}
\alias{show.query}
\title{Show preference in usual Query Languages}
\usage{
show.query(p, dialect = "EXASOL")
}
\arguments{
\item{p}{A preference}

\item{dialect}{The preference query dialect, which determines the Syntax of the returned query. This has to be one of the following:
\describe{
   \item{\code{'EXASOL'}}{Syntax of the "Skyline" Feature of the commercial database EXASOL EXASolution, version >= 5.}
    \item{\code{'Preference SQL'}}{Syntax of the Preference SQL system.
     This is a research prototype developed at the Chair of Databases and Information Systems of the University of Augsburg.
     See references for details.}
}}
}
\description{
For a given preference this shows the \code{PREFERRING} clause of a database query in different SQL dialects which support preferences.
}
\details{
There are few database systems supporting Skyline queries.
A Skyline query consists of a usual SQL query followed by a \code{PREFERRING}-clause (in some rarely used dialects also \code{SKYLINE OF}).
For example consider a database table r(a,b). The preference selection \code{psel(r, low(a) * high(b))} can be expressed by (in the Exasol dialect):

\code{SELECT * FROM r PREFERRING LOW a PLUS HIGH b}

The \code{show.query} function generates just the PREFERRING-clause, i.e. \code{show.query(low(a) * high(b))} returns

\code{PREFERRING LOW a PLUS HIGH b}

As usual in SQL queries all keywords are not case sensitive, i.e. \code{PLUS} or \code{plus} does not make any difference.
}
\examples{
show.query(low(a) * high(b))

show.query(low(a) * high(b), dialect = 'Preference SQL')
}
\references{
W. Kiessling, M. Endres, F. Wenzel (2011): The Preference SQL System - An Overview. IEEE Data Engineering Bulletin, Vol. 34 No. 3, pages 12-19.
}

