% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2_enrich_beta3.r
\name{r2_enrich_beta}
\alias{r2_enrich_beta}
\title{r2_enrich_beta}
\usage{
r2_enrich_beta(dat, v1, v2, nv, exp1)
}
\arguments{
\item{dat}{N by (M+1) matrix having variables in the order of cbind(y,x)}

\item{v1}{These can be set as v1=1, v1=2, v1=3  or any value between 1 - M based on combination}

\item{v2}{These can be set as v2=1, v2=2, v2=3, or any value between 1 - M based on combination}

\item{nv}{Sample size}

\item{exp1}{The expectation of the ratio (e.g. ratio of # SNPs in genomic partitioning)}
}
\value{
This function will estimate var(beta1^2/R^2), beta1 and R^2 are regression coefficient and the coefficient of determination from a multiple regression model, i.e. y = x1 * beta1 + x2 * beta2 +e, where y, x1 and x2 are column-standardised. The outputs are listed as follows.
\item{beta1_sq}{beta1_sq}
\item{beta2_sq}{beta2_sq}
\item{ratio1}{beta1_sq/R^2}
\item{ratio2}{beta2_sq/R^2}
\item{ratio_var1}{variance of ratio 1}
\item{ratio_var2}{variance of ratio 2}
\item{upper_ratio1}{upper limit of 95\% CI for ratio 1}
\item{lower_ratio1}{lower limit of 95\% CI for ratio 1}
\item{upper_ratio2}{upper limit of 95\% CI for ratio 2}
\item{lower_ratio2}{lower limit of 95\% CI for ratio 2}
\item{enrich_p1}{two tailed P-value for beta1_sq/R^2 is significantly different from exp1}
\item{enrich_p1_one_tail}{one tailed P-value for beta1_sq/R^2 is significantly different from exp1}
\item{enrich_p2}{P-value for beta2_sq/R2 is significantly different from (1-exp1)}
\item{enrich_p2_one_tail}{one tailed P-value for beta2_sq/R2 is significantly different from (1-exp1)}
}
\description{
This function estimates var(beta1^2/R^2),
beta1 and R^2 are regression coefficient and the coefficient
of determination from a multiple regression model,
i.e. y = x1 * beta1 + x2 * beta2 +e, where y, x1 and x2 are column-standardised
(see Olkin and Finn 1995).
y is N by 1 matrix having the dependent variable, and
x1 is N by 1 matrix having the ith explanatory variables.
x2 is N by 1 matrix having the jth explanatory variables.
v1 and v2 indicates the ith and jth column in the data
(v1 or v2 should be a single interger between 1 - M, see Arguments below).
}
\examples{
#To get the test statistic for the ratio which is significantly
#different from the expectation, this function estiamtes 
#var (beta1^2/R^2), where 
#beta1^2 and R^2 are regression coefficients and the 
#coefficient of dterminationfrom a multiple regression model,
#i.e. y = x1 * beta1 + x2 * beta2 +e, where y, x1 and x2 are 
#column-standardised.

dat=dat2
nv=length(dat$V1)
v1=c(1)
v2=c(2)
expected_ratio=0.04
output=r2_enrich_beta(dat,v1,v2,nv,expected_ratio)
output

#r2redux output

#output$beta1_sq (beta1_sq)
#0.01118301

#output$beta2_sq (beta2_sq)
#0.004980285

#output$ratio1 (beta1_sq/R^2)
#0.4392572

#output$ratio2 (beta2_sq/R^2)
#0.1956205

#output$ratio_var1 (variance of ratio 1)
#0.08042288

#output$ratio_var2 (variance of ratio 2)
#0.0431134

#output$upper_ratio1 (upper limit of 95\% CI for ratio 1)
#0.9950922

#output$lower_ratio1 (lower limit of 95\% CI for ratio 1)
#-0.1165778

#output$upper_ratio2 upper limit of 95\% CI for ratio 2)
#0.6025904

#output$lower_ratio2 (lower limit of 95\% CI for ratio 2)
#-0.2113493

#output$enrich_p1 (two tailed P-value for beta1_sq/R^2 is 
#significantly different from exp1)
#0.1591692

#output$enrich_p1_one_tail (one tailed P-value for beta1_sq/R^2 
#is significantly different from exp1)
#0.07958459

#output$enrich_p2 (two tailed P-value for beta2_sq/R2 is 
#significantly different from (1-exp1))
#0.000232035

#output$enrich_p2_one_tail (one tailed P-value for beta2_sq/R2  
#is significantly different from (1-exp1))
#0.0001160175
}
\references{
Olkin, I. and Finn, J.D. Correlations redux. Psychological Bulletin, 1995. 118(1): p. 155.
}
\keyword{a}
\keyword{beta^2}
\keyword{between}
\keyword{from}
\keyword{multiple}
\keyword{of}
\keyword{ratio}
\keyword{regression}
\keyword{variance}
