% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cc_trf.r
\name{cc_trf}
\alias{cc_trf}
\title{cc_trf function}
\usage{
cc_trf(R2, se, K, P)
}
\arguments{
\item{R2}{R2 or coefficient of determination on the observed or liability scale}

\item{se}{Standard error of R2}

\item{K}{Population prevalence}

\item{P}{The ratio of cases in the study samples}
}
\value{
This function will transform the R2 and its s.e between observed scale and liability scale.Output from the command is the lists of outcomes.
\item{R2l}{Transformed R2 on the liability scale}
\item{sel}{Transformed se on the liability scale}
\item{R2O}{Transformed R2 on the observed scale}
\item{seO}{Transformed se on the observed scale}
}
\description{
This function transforms the predictive ability (R2) and
its standard error (se) between the observed scale
and liability scale
}
\examples{
#To get the transformed R2

output=cc_trf(0.06, 0.002, 0.05, 0.05)
output

#output$R2l (transformed R2 on the liability scale)
#0.2679337

#output$sel (transformed se on the liability scale)
#0.008931123

#output$R2O (transformed R2 on the observed scale)
#0.01343616

#output$seO (transformed se on the observed scale)
#0.000447872
}
\references{
Lee, S. H., Goddard, M. E., Wray, N. R., and Visscher, P. M. A better coefficient of determination for genetic profile analysis. Genetic epidemiology,(2012). 36(3): p. 214-224.
}
\keyword{R2}
\keyword{Transformation}
\keyword{and}
\keyword{between}
\keyword{liability}
\keyword{observed}
\keyword{of}
\keyword{scale}
