\name{rtlu}
\alias{rtlu}

%- Also NEED an '\alias' for EACH other topic documented here.
\title{~ Function: R to LaTeX, Univariate analysis ~

~ Function: R to HTML, Univariate analysis ~}

\description{
  \code{rtlu} performs some basic analyses, then generates 
  code to be included in a LaTeX document to print the analyses in a (so
  nice!) LaTeX way.

  \code{rthu} does the same but generates code in HTML format.
}

\usage{
  rtlu(x,fileOut="",textBefore="",textAfter="",graphDir="graphUniv",graphName="V",type="png",limDiscrete=10)
}

\arguments{
  \item{x}{\code{[data.frame]} or \code{[vector]} : contains the
    data to analyse.}

  \item{fileOut}{\code{[character]};
    name of the output file in which
    the LaTeX or HTML summary will be saved. If empty, the code is printed on screen.}

  \item{textBefore}{\code{[character] or [vector(character)]} : before
    printing a variable analysis, some text can be inserted. If the function
    (\code{rtlu} or \code{rthu}) is applied on a single variable,
    \code{textBefore} should be of length 1. If the function is applied on a \code{data.frame},
    \code{textBefore} can have same length as the number of columns of the data.frame (this lets
    the user write a specific introduction for each variable), or can be
    of length 1. In this case, it is printed before each variable
    analysis. See examples for details.}

  \item{textAfter}{\code{[character] or [vector(character)]} : after
    printing a variable analysis, some text can be added. See
    \code{textBefore} and examples for details.}

  \item{graphDir}{\code{[character]} :
    subdirectory used to save the graphs generated by the analyses.}

  \item{graphName}{\code{[character]} or \code{[vector(character)]} :
    prefix for the graph names. If empty, the graph names are
    \code{V1} to \code{V length(data.frame)}}

  \item{type}{\code{[character]} : type of plotting device used to export the
          graphics. Can be Windows metafile, PNG, JPEG, BMP (Windows bitmap format), TIFF,
          PostScript or PDF.}

  \item{limDiscrete}{Univariate analyses distinguish two kinds of \code{numeric} :
    \code{discrete} designates \code{numeric} variables with only a few
    modalities,  \code{continuous} designates \code{numeric} variables with many
    modalities. The limit between 'few' and 'many' can be fixed by the
    user via the \code{limDiscrete} argument. By setting
    \code{limDiscrete} to 5, the user will ask \code{rtlu} (or
    \code{rthu}) to consider
    all the \code{numeric} variables with 5 modalities or more as
    \code{continuous} and all the variables with less than 5 modalities
    as \code{discrete}.

    The default value for \code{limDiscrete} is 10.}
}

\details{
  \code{rtlu} performs some basic analyses, then generates a
  code to be included in a LaTeX document to print the analyses in a (so
  nice!) LaTeX way.
  \code{rthu} performs some basic analyses, then generates a
  code to be included in a HTML document.

  Both functions perform the analyses automatically according to the
  \code{data} class. They consider four classes. The analysis of the
  variable depends on the class:
  \enumerate{
    \item factor, character and logical: Frequency ; Graph: barplot
    \item ordered: Frequency, quartile ; Graph: barplot
    \item numeric discrete: Frequency, mean, variance, quartile ; Graph: boxplot and barplot
    \item numeric continuous: Mean, variance, quartile ; Graph: boxplot and
    histogram.
  }

  On a \code{data.frame}, \code{rtlu} and \code{rthu} run the analyses on every column.
}

\value{
  \code{rtlu} and \code{rthu} generate LaTeX or HTML code respectively. They either print it on the screen, or save it in a
  file. They also generate several graphs, optionally in a different directory.
}

\section{Classical usage}{
  The use of \code{rtlu} or \code{rthu} goes through the following steps:
  \tabular{ll}{
    Step 1. \tab Load the data (usually, a \code{data.frame}).\cr
    Step 2. \tab Optionally, set some variables as \code{ordered}. \cr
    Step 3. \tab Run \code{rtlu(dataFrame,"fileOut.tex")}.\cr
  }
  See examples of application.
}

\section{Author}{
  Christophe Genolini \cr
  \email{christophe.genolini@free.fr}\cr
  PSIGIAM: Paris Sud Innovation Group in Adolescent Mental Health \cr
  INSERM U669 / Maison de Solenn / Paris\cr
  \cr
  Bernard Desgraupes \cr
  \email{bernard.desgraupes@u-paris10.fr}\cr
  University of Paris Ouest - Nanterre
}


\references{LaTeX web site \url{http://www.latex-project.org/}\cr
Data are available on line: \url{http://christophe.genolini.free.fr/EPO/EPO2007-Fraude.php}}



\seealso{
  \code{\link{rtlMainFile}},
  \code{\link{rtlb}},
  \code{\link{r2lUniv-package}},
  \code{\link{examCheating}},
  \code{\link{Sweave}},
  \code{\link[Hmisc]{latex}}
}

\examples{
### Create some data
V1 <- factor(LETTERS[floor(runif(50,1,4))])
V2 <- rnorm(50,1,1)<0
V3 <- ordered(LETTERS[floor(runif(50,1,4))])

### Create a directory for the output
r2lhOutDir <- paste(tempdir(),"rtluExample",sep="/")
if(!file.exists(r2lhOutDir)){dir.create(r2lhOutDir)}
setwd(r2lhOutDir)

### Execute rtlu
rtlu(V1,fileOut="first.tex",textBefore="\\\\section{Variable 1 to 3}",graphName="V1")
rtlu(V2,fileOut="second.tex",graphName="V2")
rtlu(V3,fileOut="third.tex",textBefore="This is variable 3",graphDir="P")
rtlMainFile(text="\\\\input{first.tex}\n\\\\input{second.tex}\n\\\\input{third.tex}")



 # # # # # # # # # # # # # # # # # # #
#   R to LaTeX, Univariate Analyses   #
 #          Real examples            #
  #        rtlu data.frame          #
   # # # # # # # # # # # # # # # # #

########################
###### Step 1: Create the data

data(examCheating)
str(examCheating)

########################
###### Step 2: ordering variable

examCheating$YearOfStudy <- ordered(examCheating$YearOfStudy,levels=c("L1","L2","L3","M1","M2"))
examCheating$Bac <- ordered(examCheating$Bac,levels=c("Remedial exam","Pass","Fairly good","Good","Very good","Summa cum laude"))
for(iColumn in 8:17){
    examCheating[,iColumn] <- ordered(examCheating[,iColumn],levels=c("Never","Rarely","Sometimes","Often","Always"))
}
str(examCheating)


########################
###### Step 3: running rtlu

### The following code will create some files.
### So we first move to a directory.
r2lhOutDir <- paste(tempdir(),"rtluReal",sep="/")
if(!file.exists(r2lhOutDir)){dir.create(r2lhOutDir)}
setwd(r2lhOutDir)

### Then we prepare the textBefore, for transition between variables

textBefore <- paste("\\\\subsection{",names(examCheating)[c(2:5,18:20)],"}",sep="")

text <- "\\\\maketitle
\\\\tableofcontents
\\\\section{Survey}
  \\\\begin{enumerate}
    \\\\item What is your age?
    \\\\item What is your gender?
    \\\\item What is your level?
    \\\\item What is your field?
    \\\\item Did you cheat at Bac?
    \\\\item Did you cheat high scool?
    \\\\item Cheating score
  \\\\end{enumerate}
\\\\section{Univariate analysis}
  \\\\input{ExamCheat-univ.tex}

\\\\section{More information?}
For a detailled analysis, see
http://christophe.genolini.free.fr/EPO/2007 Fraude/EPO2007-Fraude-Rapport.pdf"

### We can run r2lu
rtlu(examCheating[,c(2:5,18:20)],fileOut="ExamCheat-univ.tex",textBefore=textBefore)
rtlMainFile("ExamCheat-main.tex",text=text)
setwd("../..")

### Then compile main.tex twice. It is ready !
}

\keyword{print}        % Printing
\keyword{classes}      % Data type
\keyword{programming}  % Programming
\keyword{interface}    % interface to other languages
\keyword{utilities}    % Utilities
\keyword{univar}       % Simple univariate statistics




