% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmpR2_Function.R
\name{cmp_R2}
\alias{cmp_R2}
\title{Compute r2beta with a specified C matrix
Compute R2 with a specified C matrix}
\usage{
cmp_R2(c, x, SigHat, beta, method, obsperclust = NULL, nclusts = NULL)
}
\arguments{
\item{c}{Contrast matrix for fixed effects}

\item{x}{Fixed effects design matrix}

\item{SigHat}{estimated model covariance (matrix or scalar)}

\item{beta}{fixed effects estimates}

\item{method}{the method for computing r2beta}

\item{obsperclust}{number of observations per cluster (i.e. subject)}

\item{nclusts}{number of clusters (i.e. subjects)}
}
\value{
A vector with the Wald statistic (ncp), approximate Wald F
statistic (F), numerator degrees of freedom (v1), denominator degrees
of freedom (v2), and the specified r squared value (Rsq)
}
\description{
Compute r2beta with a specified C matrix
Compute R2 with a specified C matrix
}
\examples{
library(nlme)
library(lme4)
library(mgcv)
lmemod = lme(distance ~ age*Sex, random = ~1|Subject, data = Orthodont)
X = model.matrix(lmemod, data = Orthodont)
SigHat = extract.lme.cov(lmemod, data = Orthodont)
beta = fixef(lmemod)
p = length(beta)
obsperclust = as.numeric(table(lmemod$data[,'Subject']))
nclusts = length(obsperclust)
C = cbind(rep(0, p-1),diag(p-1))
partial.c = make.partial.C(p-1,p,2)

cmp_R2(c=C, x=X, SigHat=SigHat, beta=beta, obsperclust = obsperclust,
nclusts = nclusts, method = 'sgv')
cmp_R2(c=partial.c, x=X, SigHat=SigHat, beta=beta, obsperclust = obsperclust,
nclusts = nclusts, method = 'sgv')
}

