% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-LagEstimator.R
\docType{methods}
\name{plot-LagEstimator}
\alias{plot,LagEstimator,ANY-method}
\alias{plot-LagEstimator}
\title{Plot the values of a \code{\link{LagEstimator}}.}
\usage{
\S4method{plot}{LagEstimator,ANY}(x, ptw.CIs = 0.1, ratio = 3/2,
  widthlab = lcm(1), xlab = expression(omega/2 * pi), ylab = NULL,
  type.scaling = c("individual", "real-imaginary", "all"),
  frequencies = x@frequencies, type.CIs = c("naive.sd"),
  levels = intersect(x@levels[[1]], x@levels[[2]]))
}
\arguments{
\item{x}{The \code{\link{LagEstimator}} object to plot}

\item{ptw.CIs}{the confidence level for the confidence intervals to be
displayed; must be a number from [0,1]; if null, then no
confidence intervals will be plotted.}

\item{ratio}{quotient of width over height of the subplots; use this
parameter to produce landscape or portrait shaped plots.}

\item{widthlab}{width for the labels (left and bottom); default is
\code{lcm(1)}, cf. \code{\link[graphics]{layout}}.}

\item{xlab}{label that will be shown on the bottom of the plots; can be
an expression (for formulas), characters or \code{NULL} to
force omission (to save space).}

\item{ylab}{label that will be shown on the left side of the plots;
can be an expression (for formulas), characters or
\code{NULL} to force omission (to save space).}

\item{type.scaling}{a method for scaling of the subplots; currently there
are three options: \code{"individual"} will scale each of the
\code{K^2} subplots to minimum and maximum of the values
in that plot, \code{"real-imaginary"} will scale each of the
subplots displaying real parts and each of the subplots
displaying imaginary parts to the minimum and maximum of
the values display in these subportion of plots. The
option \code{"all"} will scale the subplots to the minimum and
maximum in all of the subplots.}

\item{frequencies}{a set of frequencies for which the values are to be
plotted.}

\item{type.CIs}{indicates the method to be used for determining the
confidence intervals; the methods available are those
 provided by
\code{\link{getPointwiseCIs-LagEstimator}}.}

\item{levels}{a set of levels for which the values are to be plotted.}
}
\value{
Returns the plot described in the Description section.

See Birr et al. (2015)
}
\description{
Creates a \code{K} x \code{K} plot displaying all levels combinations from the
argument \code{levels}.  
In each of the subplots either the real part (on and below the diagonal;
i. e., \eqn{\tau_1 \leq \tau_2}{tau1 <= tau2}) or the imaginary parts
(above the diagonal; i. e., \eqn{\tau_1 > \tau_2}{tau1 > tau2}) of
the lag-window estimator, for the combination of levels \eqn{\tau_1}{tau1}
 and \eqn{\tau_2}{tau2} denoted on the left and bottom margin of the plot are displayed.
}
\references{
Birr, S., Volgushev, S., Kley, T., Dette, H. & Hallin, M. (2015).
Quantile Spectral Analysis for Locally Stationary Time Series.
\url{http://arxiv.org/abs/1404.4605}.
}

