% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textplot_wordcloud.R
\name{textplot_wordcloud}
\alias{textplot_wordcloud}
\title{Plot features as a wordcloud}
\usage{
textplot_wordcloud(
  x,
  min_size = 0.5,
  max_size = 4,
  min_count = 3,
  max_words = 500,
  color = "darkblue",
  font = NULL,
  adjust = 0,
  rotation = 0.1,
  random_order = FALSE,
  random_color = FALSE,
  ordered_color = FALSE,
  labelcolor = "gray20",
  labelsize = 1.5,
  labeloffset = 0,
  fixed_aspect = TRUE,
  ...,
  comparison = FALSE
)
}
\arguments{
\item{x}{a dfm object}

\item{min_size}{size of the smallest word}

\item{max_size}{size of the largest word}

\item{min_count}{words with frequency below min_count will not be plotted}

\item{max_words}{maximum number of words to be plotted. least frequent terms
dropped.}

\item{color}{color of words from least to most frequent}

\item{font}{font-family of words and labels. Use default font if \code{NULL}.}

\item{adjust}{adjust sizes of words by a constant. Useful for non-English
words for which R fails to obtain correct sizes.}

\item{rotation}{proportion of words with 90 degree rotation}

\item{random_order}{plot words in random order. If \code{FALSE}, they will be
plotted in decreasing frequency.}

\item{random_color}{choose colors randomly from the colors. If \code{FALSE},
the color is chosen based on the frequency}

\item{ordered_color}{if \code{TRUE}, then colors are assigned to words in
order.}

\item{labelcolor}{color of group labels. Only used when \code{compariosn=TRUE}.}

\item{labelsize}{size of group labels. Only used when \code{compariosn=TRUE}.}

\item{labeloffset}{position of group labels. Only used when
\code{comparison=TRUE}.}

\item{fixed_aspect}{if \code{TRUE}, the aspect ratio is fixed. Variable
aspect ratio only supported if rotation = 0.}

\item{...}{additional parameters. Only used to make it compatible with
\pkg{wordcloud}}

\item{comparison}{if \code{TRUE}, plot a wordcloud that compares documents in
the same way as \code{\link[wordcloud]{comparison.cloud}}}
}
\description{
Plot a \link{dfm} object as a wordcloud, where the feature labels are plotted
with their sizes proportional to their numerical values in the dfm.  When
\code{comparison = TRUE}, it plots comparison word clouds by document.
}
\details{
The default is to plot the word cloud of all features, summed across
  documents.  To produce word cloud plots for specific document or set of
  documents, you need to slice out the document(s) from the dfm object.
  
  Comparison wordcloud plots may be plotted by setting \code{comparison =
  TRUE}, which plots a separate grouping for \emph{each document} in the dfm.
  This means that you will need to slice out just a few documents from the
  dfm, or to create a dfm where the "documents" represent a subset or a
  grouping of documents by some document variable.
}
\examples{
# plot the features (without stopwords) from Obama's inaugural addresses
set.seed(10)
dfmat1 <- dfm(corpus_subset(data_corpus_inaugural, President == "Obama"),
              remove = stopwords("english"), remove_punct = TRUE) \%>\%
   dfm_trim(min_termfreq = 3)
    
# basic wordcloud
textplot_wordcloud(dfmat1)

# plot in colors with some additional options
textplot_wordcloud(dfmat1, rotation = 0.25, 
                   color = rev(RColorBrewer::brewer.pal(10, "RdBu")))
  
# other display options
col <- sapply(seq(0.1, 1, 0.1), function(x) adjustcolor("#1F78B4", x))
textplot_wordcloud(dfmat1, adjust = 0.5, random_order = FALSE, 
                   color = col, rotation = FALSE)
  
# comparison plot of Obama v. Trump
dfmat2 <- dfm(corpus_subset(data_corpus_inaugural, President \%in\% c("Obama", "Trump")),
              remove = stopwords("english"), remove_punct = TRUE, groups = "President") \%>\%
    dfm_trim(min_termfreq = 3)

textplot_wordcloud(dfmat2, comparison = TRUE, max_words = 300,
                   color = c("blue", "red"))
}
\author{
Kohei Watanabe, building on code from Ian Fellows's \pkg{wordcloud}
  package.
}
\keyword{textplot}
