% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfm-methods.R
\name{topfeatures}
\alias{topfeatures}
\title{Identify the most frequent features in a dfm}
\usage{
topfeatures(x, n = 10, decreasing = TRUE, scheme = c("count",
  "docfreq"), groups = NULL)
}
\arguments{
\item{x}{the object whose features will be returned}

\item{n}{how many top features should be returned}

\item{decreasing}{If \code{TRUE}, return the \code{n} most frequent features;
otherwise return the \code{n} least frequent features}

\item{scheme}{one of \code{count} for total feature frequency (within
\code{group} if applicable), or \code{docfreq} for the document frequencies
of features}

\item{groups}{either: a character vector containing the names of document 
variables to be used for grouping; or a factor or object that can be 
coerced into a factor equal in length or rows to the number of documents. 
See \link{groups} for details.}
}
\value{
A named numeric vector of feature counts, where the names are the 
  feature labels, or a list of these if \code{groups} is given.
}
\description{
List the most (or least) frequently occurring features in a \link{dfm}, either
as a whole or separated by document.
}
\examples{
mydfm <- corpus_subset(data_corpus_inaugural, Year > 1980) \%>\%
    dfm(remove_punct = TRUE)
mydfm_nostopw <- dfm_remove(mydfm, stopwords("english"))

# most frequent features
topfeatures(mydfm)
topfeatures(mydfm_nostopw)

# least frequent features
topfeatures(mydfm_nostopw, decreasing = FALSE)

# top features of individual documents  
topfeatures(mydfm_nostopw, n = 5, groups = docnames(mydfm_nostopw))

# grouping by president last name
topfeatures(mydfm_nostopw, n = 5, groups = "President")

# features by document frequencies
tail(topfeatures(mydfm, scheme = "docfreq", n = 200))
}
