% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textplot_wordcloud.R
\name{wordcloud_comparison}
\alias{wordcloud_comparison}
\title{Internal function for textplot_wordcloud}
\usage{
wordcloud_comparison(x, min_size, max_size, min_count, max_words, color, font,
  adjust, rotation, random_order, random_color, ordered_color, labelcolor,
  labelsize, labeloffset, fixed_aspect, colors, scale, min.freq, max.words,
  random.order, rot.per, use.r.layout, title.size, ...)
}
\arguments{
\item{x}{a dfm object}

\item{min_size}{size of the smallest word}

\item{max_size}{size of the largest word}

\item{min_count}{words with frequency below min_count will not be plotted}

\item{max_words}{maximum number of words to be plotted. least frequent terms
dropped.}

\item{color}{color of words from least to most frequent}

\item{font}{font-family of words and labels. Use default font if \code{NULL}.}

\item{adjust}{ajust sizes of words by a constant. Useful for non-Engish words
for which R fails to obtain correct sizes.}

\item{rotation}{proportion of words with 90 degree rotation}

\item{random_order}{plot words in random order. If \code{FALSE}, they will be
plotted in decreasing frequency.}

\item{random_color}{choose colors randomly from the colors. If \code{FALSE},
the color is chosen based on the frequency}

\item{ordered_color}{if \code{TRUE}, then colors are assigned to words in
order.}

\item{labelcolor}{color of group labels. Only used when \code{compariosn=TRUE}.}

\item{labelsize}{size of group labels. Only used when \code{compariosn=TRUE}.}

\item{labeloffset}{position of group labels. Only used when
\code{comparison=TRUE}.}

\item{fixed_aspect}{if \code{TRUE}, the aspect ratio is fixed. Variable
aspect ratio only supported if rotation = 0.}

\item{scale}{deprecated argument}

\item{min.freq}{deprecated argument}

\item{max.words}{deprecated argument}

\item{random.order}{deprecated argument}

\item{rot.per}{deprecated argument}

\item{use.r.layout}{deprecated argument}

\item{title.size}{deprecated argument}

\item{...}{additional parameters. Only used to make it compatible with
\pkg{wordcloud}}

\item{random.color}{deprecated argument}

\item{ordered.colors}{deprecated argument}
}
\description{
This function impliments wordcloud that compares documents. Code is adopted from
\code{\link[wordcloud]{comparison.cloud}}.
}
\author{
Kohei Watanabe, build on code from Ian Fellows's \pkg{wordcloud} package.
}
\keyword{internal}
\keyword{textplot_internal}
