% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corpus_segment.R
\name{corpus_segment}
\alias{corpus_segment}
\alias{char_segment}
\title{segment texts into component elements}
\usage{
corpus_segment(x, what = c("sentences", "paragraphs", "tokens", "tags",
  "other"), delimiter = switch(what, paragraphs = "\\\\n{2}", tags =
  "##\\\\w+\\\\b", NULL), valuetype = c("regex", "fixed", "glob"),
  keepdocvars = TRUE, ...)

char_segment(x, what = c("sentences", "paragraphs", "tokens", "tags",
  "other"), delimiter = switch(what, paragraphs = "\\\\n{2}", tags =
  "##\\\\w+\\\\b", NULL), valuetype = c("regex", "fixed", "glob"),
  keepdocvars = TRUE, ...)
}
\arguments{
\item{x}{corpus object whose texts will be segmented}

\item{what}{unit of segmentation.  Current options are \code{"tokens"} 
(default), \code{"sentences"}, \code{"paragraphs"}, \code{"tags"}, and 
\code{"other"}.  Segmenting on \code{other} allows segmentation of a text 
on any user-defined value, and must be accompanied by the \code{delimiter} 
argument.  Segmenting on \code{tags} performs the same function but 
preserves the tags as a document variable in the segmented corpus.}

\item{delimiter}{delimiter defined as a \code{\link{regex}} for 
segmentation; only relevant for \code{what = "paragraphs"} (where the
default is two newlines) and \code{what = "tags"} (where the default is a
tag preceded by two pound or "hash" signs \code{##}).  Delimiter has no
effect for segmentation into tokens or sentences}

\item{valuetype}{how to interpret keyword expressions: \code{"glob"} for 
"glob"-style wildcard expressions; \code{"regex"} for regular expressions;
or \code{"fixed"} for exact matching. See \link{valuetype} for details.}

\item{keepdocvars}{(for corpus objects) if \code{TRUE}, repeat the docvar
values for each segmented text; if \code{FALSE}, drop the docvars in the
segmented corpus. Dropping the docvars might be useful in order to conserve
space or if these are not desired for the segmented corpus.}

\item{...}{provides additional arguments passed to \code{\link{tokens}}, if 
\code{what = "tokens"} is used}
}
\value{
A corpus of segmented texts.
}
\description{
Segment corpus text(s) or a character vector into tokens, sentences, 
paragraphs, or other sections. \code{segment} works on a character vector or 
corpus object, and allows the delimiters to be user-defined.  This is useful 
for breaking the texts of a corpus into smaller documents based on sentences,
or based on a user defined "tag" pattern.  See details.
}
\details{
Tokens are delimited by separators.  For tokens and sentences, these
are determined by the tokenizer behaviour in \code{\link{tokens}}.
  
  For paragraphs, the default is two carriage returns, although this could be
  changed to a single carriage return by changing the value of 
  \code{delimiter} to \code{"\\\n{1}"} which is the R version of the 
  \code{\link{regex}} for one newline character.  (You might need this if the
  document was created in a word processor, for instance, and the lines were 
  wrapped in the window rather than being hard-wrapped with a newline 
  character.)
}
\note{
Does not currently record document segments if segmenting a multi-text 
  corpus into smaller units. For this, use \link{changeunits} instead.
}
\examples{
testCorpus <- corpus(c("##INTRO This is the introduction.
                        ##DOC1 This is the first document.  Second sentence in Doc 1.
                        ##DOC3 Third document starts here.  End of third document.",
                       "##INTRO Document ##NUMBER Two starts before ##NUMBER Three."))
# add a docvar
testCorpus[["serialno"]] <- paste0("textSerial", 1:ndoc(testCorpus))
testCorpusSeg <- corpus_segment(testCorpus, "tags")
summary(testCorpusSeg)
texts(testCorpusSeg)
# segment a corpus into sentences
segmentedCorpus <- corpus_segment(corpus(data_char_ukimmig2010), "sentences")
summary(segmentedCorpus)

# same as tokenize()
identical(as.character(tokens(data_char_ukimmig2010)), 
          as.character(char_segment(data_char_ukimmig2010, what = "tokens")))

# segment into paragraphs
char_segment(data_char_ukimmig2010[3:4], "paragraphs")

# segment a text into sentences
segmentedChar <- char_segment(data_char_ukimmig2010, "sentences")
segmentedChar[3]
}
\keyword{character}
\keyword{corpus}
