% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/character-methods.R, R/corpus-methods-base.R
\name{summary.character}
\alias{summary.character}
\alias{summary.corpus}
\title{summarize a corpus or a vector of texts}
\usage{
\method{summary}{character}(object, n = 100, verbose = TRUE,
  toLower = FALSE, ...)

\method{summary}{corpus}(object, n = 100, verbose = TRUE,
  showmeta = FALSE, toLower = FALSE, ...)
}
\arguments{
\item{object}{corpus or texts to be summarized}

\item{n}{maximum number of texts to describe, default=100}

\item{verbose}{set to \code{FALSE} to turn off printed output, for instance
if you simply want to assign the output to a \code{data.frame}}

\item{toLower}{convert texts to lower case before counting types}

\item{...}{additional arguments passed through to \code{\link{tokenize}}}

\item{showmeta}{for a corpus, set to \code{TRUE} to include document-level
meta-data}
}
\description{
Displays information about a corpus or vector of texts.  For a corpus, this 
includes attributes and metadata such as date of number of texts, creation 
and source.  For texts, prints to the console a desription of the texts,
including number of types, tokens, and sentences.
}
\examples{

# summarize texts
summary(c("Testing this text.  Second sentence.", "And this one."))
summary(data_char_ukimmig2010)
myTextSummaryDF <- summary(data_char_ukimmig2010, verbose = FALSE)
head(myTextSummaryDF)
# summarize corpus information
summary(data_corpus_inaugural)
summary(data_corpus_inaugural, n=10)
mycorpus <- corpus(data_char_ukimmig2010, 
                   docvars = data.frame(party=names(data_char_ukimmig2010))) 
summary(mycorpus, showmeta=TRUE)  # show the meta-data
mysummary <- summary(mycorpus, verbose=FALSE)  # (quietly) assign the results
mysummary$Types / mysummary$Tokens             # crude type-token ratio
}
\keyword{corpus}
\keyword{internal}

