% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequences.R
\name{sequences}
\alias{sequences}
\title{find variable-length collocations with filtering}
\usage{
sequences(x, features, valuetype = c("glob", "regex", "fixed"),
  case_insensitive = TRUE, min_count = 2, max_length = 5, nested = TRUE,
  ordered = FALSE)
}
\arguments{
\item{x}{a \link{tokens} object}

\item{features}{a regular expression for filtering the features to be located
in sequences}

\item{valuetype}{how to interpret keyword expressions: \code{"glob"} for 
"glob"-style wildcard expressions; \code{"regex"} for regular expressions;
or \code{"fixed"} for exact matching. See \link{valuetype} for details.}

\item{case_insensitive}{ignore case when matching, if \code{TRUE}}

\item{min_count}{minimum frequency of sequences for which parameters are estimated}

\item{max_length}{maxium length of sequences which are collected}

\item{nested}{if true, collect all the subsequences of a longer sequence as separate entities.
e.g. in a sequence of capitalized words "United States Congress", "States Congress" is considered 
as a subsequence. But "United States" is not a subsequence because it is followed by "Congress".}

\item{ordered}{if true, use the Blaheta-Johnson method that distinguishs between 
the order of words, and tends to promote rare sequences.}
}
\description{
This function automatically identifies contiguous collocations consisting of
variable-length term sequences whose frequency is unlikey to have occurred by
chance.  The algorithm is based on Blaheta and Johnson's "Unsupervised 
Learning of Multi-Word Verbs".
}
\examples{
toks <- tokens(corpus_segment(data_corpus_inaugural, what = "sentence"))
toks <- tokens_select(toks, stopwords("english"), "remove", padding = TRUE)

# extracting multi-part proper nouns (capitalized terms)
seqs <- sequences(toks, "^([A-Z][a-z\\\\-]{2,})", valuetype="regex", case_insensitive = FALSE)
head(seqs, 10)

# types can be any words
seqs2 <- sequences(toks, "^([a-z]+)$", valuetype="regex", case_insensitive = FALSE, 
                   min_count = 2, ordered = TRUE)
head(seqs2, 10)

}
\author{
Kohei Watanabe
}
\references{
Blaheta, D., & Johnson, M. (2001). 
  \href{http://web.science.mq.edu.au/~mjohnson/papers/2001/dpb-colloc01.pdf}{Unsupervised
   learning of multi-word verbs}. Presented at the ACLEACL Workshop on the 
  Computational Extraction, Analysis and Exploitation of Collocations.
}
\keyword{collocations}

