% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/dataDocs.R, R/syllables.R
\docType{data}
\name{syllables}
\alias{englishSyllables}
\alias{syllables}
\alias{syllables.character}
\title{count syllables in a text}
\source{
\code{englishSyllables} is built from the freely available CMU pronunciation dictionary at \url{http://www.speech.cs.cmu.edu/cgi-bin/cmudict}.
}
\usage{
syllables(x, ...)

\method{syllables}{character}(x, syllableDict = englishSyllables, ...)
}
\arguments{
\item{x}{character vector or list of character vectors whose syllables will
be counted}

\item{...}{additional arguments passed to clean}

\item{syllableDict}{a named numeric vector of syllable counts where the names
are lower case tokens.  The default is \link{englishSyllables}, an English
pronunciation dictionary from CMU.}
}
\value{
numeric Named vector or list of counts of the number of syllables for
  each element of x. When a word is not available in the lookup table, its
  syllables are estimated by counting the number of (English) vowels in the
  word.
}
\description{
This function takes a text and returns a count of the number of
syllables it contains. For British English words, the syllable count is exact
and looked up from the CMU pronunciation dictionary, from the default
syllable dictionary \code{englishSyllables}. For any word not in the
dictionary the syllable count is estimated by counting vowel clusters.

\code{englishSyllables} is a quanteda-supplied data object consisting of a
named numeric vector of syllable counts for the words used as names.  This is
the default object used to count English syllables.  This object that can be
accessed directly, but we strongly encourage you to access it only through
the \code{syllables()} wrapper function.
}
\examples{
syllables("This is an example sentence.")
syllables(tokenize("This is an example sentence.", simplify=TRUE))
myTexts <- c(text1 = "Text one.",
             text2 = "Superduper text number two.",
             text3 = "One more for the road.")
syllables(myTexts)
syllables("supercalifragilisticexpialidocious")
}

