"use strict";

// Generated by CoffeeScript 2.2.2
// scat2scat: scatterplot driving another scatterplot
// Karl W Broman
var scat2scat;

scat2scat = function scat2scat(widgetdiv, scat1data, scat2data, chartOpts) {
  var axispos, chartdivid, g_left, g_right, height, leftchart, make_right_chart, margin, nxticks1, nxticks2, nyticks1, nyticks2, pointcolor1, pointcolor2, pointsize1, pointsize2, pointstroke1, pointstroke2, rectcolor, ref, ref1, ref10, ref11, ref12, ref13, ref14, ref15, ref16, ref17, ref18, ref19, ref2, ref20, ref21, ref22, ref23, ref24, ref25, ref26, ref27, ref28, ref29, ref3, ref30, ref31, ref32, ref33, ref34, ref4, ref5, ref6, ref7, ref8, ref9, rightchart, rotate_ylab1, rotate_ylab2, svg, title1, titlepos, widgetdivid, width, xNA, xlab1, xlab2, xlim1, xlim2, xticks1, xticks2, yNA, ylab1, ylab2, ylim1, ylim2, yticks1, yticks2;
  // chartOpts start
  height = (ref = chartOpts != null ? chartOpts.height : void 0) != null ? ref : 500; // height of chart in pixels
  width = (ref1 = chartOpts != null ? chartOpts.width : void 0) != null ? ref1 : 800; // width of chart in pixels
  title1 = (ref2 = (ref3 = chartOpts != null ? chartOpts.title1 : void 0) != null ? ref3 : chartOpts != null ? chartOpts.title : void 0) != null ? ref2 : ""; // title for left panel
  margin = (ref4 = chartOpts != null ? chartOpts.margin : void 0) != null ? ref4 : {
    left: 60,
    top: 40,
    right: 40,
    bottom: 40,
    inner: 5 // margins in pixels (left, top, right, bottom, inner)
  };
  axispos = (ref5 = chartOpts != null ? chartOpts.axispos : void 0) != null ? ref5 : {
    xtitle: 25,
    ytitle: 30,
    xlabel: 5,
    ylabel: 5 // position of axis labels in pixels (xtitle, ytitle, xlabel, ylabel)
  };
  titlepos = (ref6 = chartOpts != null ? chartOpts.titlepos : void 0) != null ? ref6 : 20; // position of chart title in pixels
  xlab1 = (ref7 = chartOpts != null ? chartOpts.xlab1 : void 0) != null ? ref7 : "X"; // x-axis label for left panel
  ylab1 = (ref8 = chartOpts != null ? chartOpts.ylab1 : void 0) != null ? ref8 : "Y"; // y-axis label for left panel
  xlab2 = (ref9 = chartOpts != null ? chartOpts.xlab2 : void 0) != null ? ref9 : "X"; // x-axis label for right panel (can be a vector, with separate values for each dataset in `scat2data`)
  ylab2 = (ref10 = chartOpts != null ? chartOpts.ylab2 : void 0) != null ? ref10 : "Y"; // y-axis label for right panel (can be a vector, with separate values for each dataset in `scat2data`)
  xlim1 = (ref11 = chartOpts != null ? chartOpts.xlim1 : void 0) != null ? ref11 : null; // x-axis limits for left panel
  xticks1 = (ref12 = chartOpts != null ? chartOpts.xticks1 : void 0) != null ? ref12 : null; // vector of tick positions on x-axis for left panel
  nxticks1 = (ref13 = chartOpts != null ? chartOpts.nxticks1 : void 0) != null ? ref13 : 5; // no. ticks on x-axis for left panel
  ylim1 = (ref14 = chartOpts != null ? chartOpts.ylim1 : void 0) != null ? ref14 : null; // y-axis limits for left panel
  yticks1 = (ref15 = chartOpts != null ? chartOpts.yticks1 : void 0) != null ? ref15 : null; // vector of tick positions on y-axis for left panel
  nyticks1 = (ref16 = chartOpts != null ? chartOpts.nyticks1 : void 0) != null ? ref16 : 5; // no. ticks on y-axis for left panel
  xlim2 = (ref17 = chartOpts != null ? chartOpts.xlim2 : void 0) != null ? ref17 : null; // x-axis limits for right panel
  xticks2 = (ref18 = chartOpts != null ? chartOpts.xticks2 : void 0) != null ? ref18 : null; // vector of tick positions on x-axis for right panel
  nxticks2 = (ref19 = chartOpts != null ? chartOpts.nxticks2 : void 0) != null ? ref19 : 5; // no. ticks on x-axis for right panel
  ylim2 = (ref20 = chartOpts != null ? chartOpts.ylim2 : void 0) != null ? ref20 : null; // y-axis limits for right panel
  yticks2 = (ref21 = chartOpts != null ? chartOpts.yticks2 : void 0) != null ? ref21 : null; // vector of tick positions on y-axis for right panel
  nyticks2 = (ref22 = chartOpts != null ? chartOpts.nyticks2 : void 0) != null ? ref22 : 5; // no. ticks on y-axis for right panel
  rectcolor = (ref23 = chartOpts != null ? chartOpts.rectcolor : void 0) != null ? ref23 : "#E6E6E6"; // color of background rectangle
  pointcolor1 = (ref24 = chartOpts != null ? chartOpts.pointcolor1 : void 0) != null ? ref24 : null; // colors for points for left panel
  pointsize1 = (ref25 = chartOpts != null ? chartOpts.pointsize1 : void 0) != null ? ref25 : 3; // size of points in pixels for left panel
  pointstroke1 = (ref26 = chartOpts != null ? chartOpts.pointstroke1 : void 0) != null ? ref26 : "black"; // color of outer circle for points for left panel
  pointcolor2 = (ref27 = chartOpts != null ? chartOpts.pointcolor2 : void 0) != null ? ref27 : null; // colors for points for right panel
  pointsize2 = (ref28 = chartOpts != null ? chartOpts.pointsize2 : void 0) != null ? ref28 : 3; // size of points in pixels for right panel
  pointstroke2 = (ref29 = chartOpts != null ? chartOpts.pointstroke2 : void 0) != null ? ref29 : "black"; // color of outer circle for points for right panel
  rotate_ylab1 = (ref30 = chartOpts != null ? chartOpts.rotate_ylab1 : void 0) != null ? ref30 : null; // whether to rotate the y-axis label in left panel
  rotate_ylab2 = (ref31 = chartOpts != null ? chartOpts.rotate_ylab2 : void 0) != null ? ref31 : null; // whether to rotate the y-axis label in right panel
  xNA = (ref32 = chartOpts != null ? chartOpts.xNA : void 0) != null ? ref32 : {
    handle: true,
    force: false,
    width: 15,
    gap: 10 // treatment of missing values (handle=T/F, force=T/F, width, gap)
  };
  yNA = (ref33 = chartOpts != null ? chartOpts.yNA : void 0) != null ? ref33 : {
    handle: true,
    force: false,
    width: 15,
    gap: 10 // treatment of missing values (handle=T/F, force=T/F, width, gap)
  };
  // chartOpts end
  chartdivid = (ref34 = chartOpts != null ? chartOpts.chartdivid : void 0) != null ? ref34 : 'chart';
  widgetdivid = d3.select(widgetdiv).attr('id');
  // make sure list args have all necessary bits
  margin = d3panels.check_listarg_v_default(margin, {
    left: 60,
    top: 40,
    right: 40,
    bottom: 40,
    inner: 5
  });
  axispos = d3panels.check_listarg_v_default(axispos, {
    xtitle: 25,
    ytitle: 30,
    xlabel: 5,
    ylabel: 5
  });
  xNA = d3panels.check_listarg_v_default(xNA, {
    handle: true,
    force: false,
    width: 15,
    gap: 10
  });
  yNA = d3panels.check_listarg_v_default(yNA, {
    handle: true,
    force: false,
    width: 15,
    gap: 10
  });
  // force xlab2, ylab2 to be arrays of character strings of length scat2data
  xlab2 = d3panels.expand2vector(xlab2, scat2data.length);
  ylab2 = d3panels.expand2vector(ylab2, scat2data.length);
  leftchart = d3panels.scatterplot({
    height: height,
    width: width / 2,
    margin: margin,
    axispos: axispos,
    titlepos: titlepos,
    xlab: xlab1,
    ylab: ylab1,
    title: title1,
    ylim: ylim1,
    xlim: xlim1,
    xticks: xticks1,
    nxticks: nxticks1,
    yticks: yticks1,
    nyticks: nyticks1,
    rectcolor: rectcolor,
    pointcolor: pointcolor1,
    pointsize: pointsize1,
    pointstroke: pointstroke1,
    rotate_ylab: rotate_ylab1,
    xNA: {
      handle: xNA.handle,
      force: xNA.force
    },
    xNA_size: {
      width: xNA.width,
      gap: xNA.gap
    },
    yNA: {
      handle: yNA.handle,
      force: yNA.force
    },
    yNA_size: {
      width: yNA.width,
      gap: yNA.gap
    },
    tipclass: widgetdivid
  });
  svg = d3.select(widgetdiv).select("svg");
  g_left = svg.append("g").attr("id", "scat1");
  leftchart(g_left, scat1data);
  // increase size of point on mouseover
  leftchart.points().on("mouseover", function (d) {
    return d3.select(this).attr("r", pointsize1 * 2);
  }).on("mouseout", function (d) {
    return d3.select(this).attr("r", pointsize1);
  }).on("click", function (d, i) {
    if (typeof rightchart !== "undefined" && rightchart !== null) {
      rightchart.remove();
    }
    return make_right_chart(i);
  });
  rightchart = null;
  g_right = svg.append("g").attr("id", "scat2").attr("transform", "translate(" + width / 2 + ",0)");
  make_right_chart = function make_right_chart(index) {
    rightchart = d3panels.scatterplot({
      height: height,
      width: width / 2,
      margin: margin,
      axispos: axispos,
      titlepos: titlepos,
      xlab: xlab2[index],
      ylab: ylab2[index],
      title: scat1data.indID[index],
      ylim: ylim2,
      xlim: xlim2,
      xticks: xticks2,
      nxticks: nxticks2,
      yticks: yticks2,
      nyticks: nyticks2,
      rectcolor: rectcolor,
      pointcolor: pointcolor2,
      pointsize: pointsize2,
      pointstroke: pointstroke2,
      rotate_ylab: rotate_ylab2,
      xNA: {
        handle: xNA.handle,
        force: xNA.force
      },
      xNA_size: {
        width: xNA.width,
        gap: xNA.gap
      },
      yNA: {
        handle: yNA.handle,
        force: yNA.force
      },
      yNA_size: {
        width: yNA.width,
        gap: yNA.gap
      },
      tipclass: widgetdivid
    });
    return rightchart(g_right, scat2data[index]);
  };
  if (chartOpts.heading != null) {
    d3.select("div#htmlwidget_container").insert("h2", ":first-child").html(chartOpts.heading).style("font-family", "sans-serif");
  }
  if (chartOpts.caption != null) {
    d3.select("body").append("p").attr("class", "caption").html(chartOpts.caption);
  }
  if (chartOpts.footer != null) {
    return d3.select("body").append("div").html(chartOpts.footer).style("font-family", "sans-serif");
  }
};