% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zz_help_files.R
\name{qsave_handle}
\alias{qsave_handle}
\title{qsave_handle}
\usage{
qsave_handle(x, handle,
preset = "high", algorithm = "zstd", compress_level = 4L,
shuffle_control = 15L, check_hash=TRUE)
}
\arguments{
\item{x}{The object to serialize.}

\item{handle}{A windows handle external pointer.}

\item{preset}{One of \code{"fast"}, \code{"balanced"}, \code{"high"} (default), \code{"archive"}, \code{"uncompressed"} or \code{"custom"}. See section \emph{Presets} for details.}

\item{algorithm}{\strong{Ignored unless \code{preset = "custom"}.} Compression algorithm used: \code{"lz4"}, \code{"zstd"}, \code{"lz4hc"}, \code{"zstd_stream"} or \code{"uncompressed"}.}

\item{compress_level}{\strong{Ignored unless \code{preset = "custom"}.} The compression level used.

For lz4, this number must be > 1 (higher is less compressed).

For zstd, a number  between \code{-50} to \code{22} (higher is more compressed). Due to the format of qs, there is very little benefit to compression levels > 5
or so.}

\item{shuffle_control}{\strong{Ignored unless \code{preset = "custom"}.} An integer setting the use of byte shuffle compression. A value between \code{0} and \code{15}
(default \code{15}). See section \emph{Byte shuffling} for details.}

\item{check_hash}{Default \code{TRUE}, compute a hash which can be used to verify file integrity during serialization.}
}
\value{
The total number of bytes written to the file (returned invisibly).
}
\description{
Saves an object to a windows handle.
}
\details{
This function serializes and compresses R objects using block compression with the option of byte shuffling.
}
\section{Presets}{
There are lots of possible parameters. To simplify usage, there are four main presets that are performant over a large variety of data:
\itemize{
\item \strong{\code{"fast"}} is a shortcut for \code{algorithm = "lz4"}, \code{compress_level = 100} and \code{shuffle_control = 0}.
\item \strong{\code{"balanced"}} is a shortcut for \code{algorithm = "lz4"}, \code{compress_level = 1} and \code{shuffle_control = 15}.
\item \strong{\code{"high"}} is a shortcut for \code{algorithm = "zstd"}, \code{compress_level = 4} and \code{shuffle_control = 15}.
\item \strong{\code{"archive"}} is a shortcut for \code{algorithm = "zstd_stream"}, \code{compress_level = 14} and \code{shuffle_control = 15}. (\code{zstd_stream} is currently
single-threaded only)
}

To gain more control over compression level and byte shuffling, set \code{preset = "custom"}, in which case the individual parameters \code{algorithm},
\code{compress_level} and \code{shuffle_control} are actually regarded.
}

\section{Byte shuffling}{
The parameter \code{shuffle_control} defines which numerical R object types are subject to \emph{byte shuffling}. Generally speaking, the more ordered/sequential an
object is (e.g., \code{1:1e7}), the larger the potential benefit of byte shuffling. It is not uncommon to improve compression ratio or compression speed by
several orders of magnitude. The more random an object is (e.g., \code{rnorm(1e7)}), the less potential benefit there is, even negative benefit is possible.
Integer vectors almost always benefit from byte shuffling, whereas the results for numeric vectors are mixed. To control block shuffling, add +1 to the
parameter for logical vectors, +2 for integer vectors, +4 for numeric vectors and/or +8 for complex vectors.
}

