% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qris.R
\name{ghat}
\alias{ghat}
\title{Calculate the weighted Kaplan-Meier estimate}
\usage{
ghat(Time, censor, wgt = 1)
}
\arguments{
\item{Time}{is a vector of observed time, which is minimum of failure time and censored time}

\item{censor}{is a vector of censoring indicator (not censored = 1, censored = 0)}

\item{wgt}{is a vector of weight}
}
\value{
A data frame containing the following components:
\describe{
  \item{deathtime}{the observed time}
  \item{ndeath}{a vector of number of subject who experienced event at deathtime}
  \item{nrisk}{a vector of number of subject who are possible to experience event at deathtime}
  \item{survp}{a vector of survival probability at deathtime}
  }
}
\description{
Calculate the weighted Kaplan-Meier estimate
}
