% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rm_hash.R
\name{rm_hash}
\alias{rm_hash}
\alias{ex_hash}
\title{Remove/Replace/Extract Hash Tags}
\usage{
rm_hash(
  text.var,
  trim = !extract,
  clean = TRUE,
  pattern = "@rm_hash",
  replacement = "",
  extract = FALSE,
  dictionary = getOption("regex.library"),
  ...
)

ex_hash(
  text.var,
  trim = !extract,
  clean = TRUE,
  pattern = "@rm_hash",
  replacement = "",
  extract = TRUE,
  dictionary = getOption("regex.library"),
  ...
)
}
\arguments{
\item{text.var}{The text variable.}

\item{trim}{logical.  If \code{TRUE} removes leading and trailing white 
spaces.}

\item{clean}{trim logical.  If \code{TRUE} extra white spaces and escaped 
character will be removed.}

\item{pattern}{A character string containing a regular expression (or 
character string for \code{fixed = TRUE}) to be matched in the given 
character vector.  Default, \code{@rm_hash} uses the 
\code{rm_hash} regex from the regular expression dictionary from 
the \code{dictionary} argument.}

\item{replacement}{Replacement for matched \code{pattern}.}

\item{extract}{logical.  If \code{TRUE} the hash tags are extracted into a 
list of vectors.}

\item{dictionary}{A dictionary of canned regular expressions to search within 
if \code{pattern} begins with \code{"@rm_"}.}

\item{\dots}{Other arguments passed to \code{\link[base]{gsub}}.}
}
\value{
Returns a character string with hash tags removed.
}
\description{
Remove/replace/extract hash tags from a string.
}
\examples{
x <- c("@hadley I like #rstats for #ggplot2 work.",
    "Difference between #magrittr and #pipeR, both implement pipeline operators for #rstats: 
        http://renkun.me/r/2014/07/26/difference-between-magrittr-and-pipeR.html @timelyportfolio",
    "Slides from great talk: @ramnath_vaidya: Interactive slides from Interactive Visualization 
        presentation #user2014. http://ramnathv.github.io/user2014-rcharts/#1"
)

rm_hash(x)
rm_hash(rm_tag(x))
ex_hash(x)

## remove just the hash symbol
rm_hash(x, replace="\\\\3")
}
\references{
The hash tag regular expression was taken from: 
\url{https://stackoverflow.com/a/25096474/1000343}
}
\seealso{
\code{\link[base]{gsub}},
\code{\link[stringi]{stri_extract_all_regex}}

Other rm_ functions: 
\code{\link{rm_abbreviation}()},
\code{\link{rm_between}()},
\code{\link{rm_bracket}()},
\code{\link{rm_caps_phrase}()},
\code{\link{rm_caps}()},
\code{\link{rm_citation_tex}()},
\code{\link{rm_citation}()},
\code{\link{rm_city_state_zip}()},
\code{\link{rm_city_state}()},
\code{\link{rm_date}()},
\code{\link{rm_default}()},
\code{\link{rm_dollar}()},
\code{\link{rm_email}()},
\code{\link{rm_emoticon}()},
\code{\link{rm_endmark}()},
\code{\link{rm_nchar_words}()},
\code{\link{rm_non_ascii}()},
\code{\link{rm_non_words}()},
\code{\link{rm_number}()},
\code{\link{rm_percent}()},
\code{\link{rm_phone}()},
\code{\link{rm_postal_code}()},
\code{\link{rm_repeated_characters}()},
\code{\link{rm_repeated_phrases}()},
\code{\link{rm_repeated_words}()},
\code{\link{rm_tag}()},
\code{\link{rm_time}()},
\code{\link{rm_title_name}()},
\code{\link{rm_url}()},
\code{\link{rm_white}()},
\code{\link{rm_zip}()}
}
\author{
\href{https://stackoverflow.com/}{stackoverflow's} hwnd and Tyler Rinker <tyler.rinker@gmail.com>.
}
\concept{rm_ functions}
\keyword{hash}
\keyword{twitter}
