% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rm_citation_tex.R
\name{rm_citation_tex}
\alias{rm_citation_tex}
\title{Remove/Replace/Extract LaTeX Citations}
\usage{
rm_citation_tex(text.var, trim = !extract, clean = TRUE,
  pattern = "@rm_citation_tex", replacement = "", extract = FALSE,
  split = extract, unlist.extract = TRUE,
  dictionary = getOption("regex.library"), ...)
}
\arguments{
\item{text.var}{The text variable.}

\item{trim}{logical.  If \code{TRUE} removes leading and trailing white
spaces.}

\item{clean}{trim logical.  If \code{TRUE} extra white spaces and escaped
character will be removed.}

\item{pattern}{A character string containing a regular expression (or
character string).}

\item{replacement}{Replacement for matched \code{pattern}.}

\item{extract}{logical.  If \code{TRUE} the dates are extracted into a
list of vectors.}

\item{split}{logical.  If \code{TRUE} and \code{extract = TRUE} the bibkey
will be removed from the LaTeX citation code curly braces and split on
commas.}

\item{unlist.extract}{logical.  If \code{TRUE} the splits from between LaTeX
citation code curly braces will be unlisted. if \code{FALSE} the list
structure (1 per citation code curly brace) will be retained.}

\item{dictionary}{A dictionary of canned regular expressions to search within
if \code{pattern} begins with \code{"@rm_"}.}

\item{\dots}{Additional arguments passed to
\code{\link[qdapRegex]{rm_default}}.}
}
\value{
Returns a character string with citations (bibkeys) removed.
}
\description{
Remove/replace/extract LaTeX citations from a string.
}
\examples{
x <- c(
    "I say \\\\parencite*{Ted2005, Moe1999} go there in \\\\textcite{Few2010} said to.",
    "But then \\\\authorcite{Ware2013} said it was so \\\\pcite[see][p. 22]{Get9999c}.",
    "then I \\\\citep[p. 22]{Foo1882c} him")

rm_citation_tex(x)
rm_citation_tex(x, replacement="[[CITATION]]")
rm_citation_tex(x, extract=TRUE)
}
\seealso{
\code{\link[base]{gsub}},
\code{\link[stringi]{stri_extract_all_regex}}

Other rm_.functions: \code{\link{as_numeric}},
  \code{\link{as_numeric2}}, \code{\link{rm_number}};
  \code{\link{as_time}}, \code{\link{as_time2}},
  \code{\link{rm_time}}, \code{\link{rm_transcript_time}};
  \code{\link{rm_abbreviation}}; \code{\link{rm_angle}},
  \code{\link{rm_bracket}},
  \code{\link{rm_bracket_multiple}},
  \code{\link{rm_curly}}, \code{\link{rm_round}},
  \code{\link{rm_square}}; \code{\link{rm_between}},
  \code{\link{rm_between_multiple}};
  \code{\link{rm_caps_phrase}}; \code{\link{rm_caps}};
  \code{\link{rm_citation}};
  \code{\link{rm_city_state_zip}};
  \code{\link{rm_city_state}}; \code{\link{rm_date}};
  \code{\link{rm_default}}; \code{\link{rm_dollar}};
  \code{\link{rm_email}}; \code{\link{rm_emoticon}};
  \code{\link{rm_endmark}}; \code{\link{rm_hash}};
  \code{\link{rm_nchar_words}}; \code{\link{rm_non_ascii}};
  \code{\link{rm_non_words}}; \code{\link{rm_percent}};
  \code{\link{rm_phone}}; \code{\link{rm_postal_code}};
  \code{\link{rm_repeated_characters}};
  \code{\link{rm_repeated_phrases}};
  \code{\link{rm_repeated_words}}; \code{\link{rm_tag}};
  \code{\link{rm_title_name}};
  \code{\link{rm_twitter_url}}, \code{\link{rm_url}};
  \code{\link{rm_white}}, \code{\link{rm_white_bracket}},
  \code{\link{rm_white_colon}},
  \code{\link{rm_white_comma}},
  \code{\link{rm_white_endmark}},
  \code{\link{rm_white_lead}},
  \code{\link{rm_white_lead_trail}},
  \code{\link{rm_white_multiple}},
  \code{\link{rm_white_punctuation}},
  \code{\link{rm_white_trail}}; \code{\link{rm_zip}}
}
\keyword{bibkey}
\keyword{citation}

