% Generated by roxygen2 (4.0.2): do not edit by hand
\name{rm_abbreviation}
\alias{rm_abbreviation}
\title{Remove/Replace/Extract Abbreviations}
\usage{
rm_abbreviation(text.var, trim = !extract, clean = TRUE,
  pattern = "@rm_abbreviation", replacement = "", extract = FALSE,
  dictionary = getOption("regex.library"), ...)
}
\arguments{
\item{text.var}{The text variable.}

\item{trim}{logical.  If \code{TRUE} removes leading and trailing white
spaces.}

\item{clean}{trim logical.  If \code{TRUE} extra white spaces and escaped
character will be removed.}

\item{pattern}{A character string containing a regular expression (or
character string for \code{fixed = TRUE}) to be matched in the given
character vector.  Default, \code{@rm_abbreviation} uses the
\code{rm_abbreviation} regex from the regular expression dictionary from
the \code{dictionary} argument.}

\item{replacement}{Replacement for matched \code{pattern}.}

\item{extract}{logical.  If \code{TRUE} the abbreviations are extracted into a
list of vectors.}

\item{dictionary}{A dictionary of canned regular expressions to search within
if \code{pattern} begins with \code{"@rm_"}.}

\item{\dots}{Other arguments passed to \code{\link[base]{gsub}}.}
}
\value{
Returns a character string with abbreviations removed.
}
\description{
Remove/replace/extract abbreviations from a string containing lower case or
capital letters followed by a period and then an optional space (this must be
repeated 2 or more times).
}
\examples{
x <- c("I want $2.33 at 2:30 p.m. to go to A.n.p.",
    "She will send it A.S.A.P. (e.g. as soon as you can) said I.",
    "Hello world.", "In the U. S. A.")
rm_abbreviation(x)
rm_abbreviation(x, extract=TRUE)
}
\seealso{
\code{\link[base]{gsub}},
\code{\link[stringi]{stri_extract_all_regex}}
}
\keyword{abbreviation}

